<?php
/**
 * Button X
 *
 * This file is used social buttons functionality.
 *
 * @package Buttons X
 * @since 0.1
 */
// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) )
	exit;

if( !class_exists( 'Btnsx_Counter_Social' ) ) {
	
	class Btnsx_Counter_Social {

		private static $instance;
		private $cache;
		private $mc_list_url;

		/**
		 * Initiator
		 * @since 0.1
		 */
		public static function init(){
			return self::$instance;
		}

		/**
		 * Constructor
		 * @since 0.1
		 */
		public function __construct() {
			global $wp_version;
			$this->cache = isset( $btnsx_settings['social_counters_cache'] ) && $btnsx_settings['social_counters_cache'] != '' ? $btnsx_settings['social_counters_cache'] : '24';
			$this->cache = intval( $this->cache ) * 60 * 60;
			// execute code if minimum wp version is 4 n above else throw notice.
			if ( $wp_version >= BTNSX__MIN_WP_VERSION ) {
				require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.form.design.php' );
				require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.form.php' );
				// admin functionality.
				add_action( 'init', array( $this, 'register_cpt' ), 49 );
				add_action( 'init', array( $this, 'register_taxonomies' ) );
				add_action( 'add_meta_boxes', array( $this, 'register_meta_boxes' ) );
				add_action( 'do_meta_boxes', array( $this, 'remove_extra_meta_boxes' ) );
				add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ), 50 );
				add_action( 'manage_buttons-x-cs_posts_custom_column', array( $this, 'column_preview' ), 10, 2 );
				add_action( 'save_post_buttons-x-cs', array( $this, 'save_data' ) );
				add_filter( 'post_updated_messages', array( $this, 'updated_messages' ) );
				add_filter( 'post_row_actions', array( $this, 'row_actions' ), 10, 2 );
				add_filter( 'manage_buttons-x-cs_posts_columns', array( $this, 'columns' ) );
				add_shortcode( 'btnsx_social_counter', array( $this, 'shortcode' ) );
				// add_filter( 'the_content', array( $this, 'content_filter' ) );.
				add_filter( 'views_edit-buttons-x-cs', array( $this, 'screen_meta_view' ) );
				// add_action( 'admin_head', array( $this, 'admin_head' ) );.
				add_action( 'wp_enqueue_scripts', array( $this, 'public_enqueue_scripts' ), 51 );
				add_action( 'post_submitbox_misc_actions', array( $this, 'publishing_actions' ) );
			} else {
				add_action( 'admin_notices', array( $this, 'dependency_notice' ) );
			}
		}

		/**
		 * Function to rest button options
		 * @since  1.8.43
		 * @return string
		 */
		public function publishing_actions() {
		    global $post;
		    if ( $post->post_type === 'buttons-x-cs' ) {
		        echo '<div class="misc-pub-section misc-pub-btnsx-options-reset"><i id="btnsx_options_reset_icon" class="fa fa-refresh" style="font-size:16px;color:#82878c;margin-right:10px;"></i><a id="btnsx_options_reset" href="javascript:void(0)">' . __( 'Reset Options', 'btnsx' ) . '</a></div>';
		        echo '<div class="misc-pub-section misc-pub-btnsx-options-reset"><i id="btnsx_options_clone_icon" class="fa fa-clone" style="font-size:16px;color:#82878c;margin-right:10px;"></i><a id="btnsx_options_clone" href="edit.php?post_type=buttons-x-dual&btnsx-clone=' . $post->ID . '">' . __( 'Clone Button', 'btnsx' ) . '</a></div>';
		    }
		}

		/**
		 * Add packs and tags links on social buttons list page
		 * @since  1.7.5
		 * @param  array    $views
		 * @return array
		 */
		public function screen_meta_view( $views ){
		    $packs = count(get_terms('btnsx_cs_pack'));
		    $tags = count(get_terms('btnsx_cs_tag'));
		    $views['packs'] = "<a href='edit-tags.php?taxonomy=btnsx_cs_pack&post_type=buttons-x-cs'>".__('Packs','btnsx')." <span class='count'>(".$packs.")</span></a>";
		    $views['tags'] = "<a href='edit-tags.php?taxonomy=btnsx_cs_tag&post_type=buttons-x-cs'>".__('Tags','btnsx')." <span class='count'>(".$tags.")</span></a>";
		    return $views;
		}

		/**
		 * Filter content to output social buttons
		 * @since  0.1
		 * @param  string    $content
		 * @return string
		 */
		public function content_filter( $content ) {

			global $post;
			global $btnsx_settings;
			$before_content = '';
			$after_content = '';

			$btnsx_settings[ 'social_counter' ] = isset( $btnsx_settings[ 'social_counter' ] ) ? $btnsx_settings[ 'social_counter' ] : array();

		    if ( in_the_loop() && in_array( $post->post_type, $btnsx_settings[ 'social_counter' ] )  ) {
		    	$buttons_meta = get_post_meta( $post->ID, 'btnsx_cs_post_meta', true );
		    	if( $buttons_meta != '' ) {
			    	// Social buttons to be displayed
			    	foreach( $buttons_meta as $key => $value ) {
			    		$value = maybe_unserialize( $value );
			    		if( $key === 'before_content' && is_array( $value ) ) {
				    		foreach ( $value as $option => $id ) {
				    			if( $id != '' ) {
					    			$before_content .= do_shortcode( '[btnsx_social_counter id="' . $id . '"]' );
				    			}
				    		}
				    	}
				    	if ( $key === 'after_content' && is_array( $value ) ) {
				    		foreach ( $value as $option => $id ) {
				    			if( $id != '' ) {
					    			$after_content .= do_shortcode( '[btnsx_social_counter id="' . $id . '"]' );
				    			}
				    		}
				    	}
			    	}
			    }
		    }
		    // Returns the content.
		    return $before_content . $content . $after_content;
		}

		/**
	     * Button short code
	     * @param $atts 
	     * @since 0.1
	     */
	    public function shortcode( $atts, $content = '' ) {

	    	extract( shortcode_atts( array(
			
				// General
					'id'								=> '',
					'url'								=> '',
					'order'								=> '',
					'theme'								=> '',

		        // Facebook
		        	'fb_app_id'							=> '',
		        	'fb_page_id'						=> '',
		        	'likes'								=> '',

		        // Twitter
		        	'tweets'							=> '',
		        	'tw_username'						=> '',

		        // Google Plus
		        	'plusones'							=> '',
		        	'gp_page_id'						=> '',

		        // StumbleUpon
		        	'stumbles'							=> '',

		        // Youtube
		        	'yt_app_id'							=> '',
		        	'yt_channel_id'						=> '',

		        // Vimeo
		        	'vm_app_id'							=> '',
		        	'vm_channel_id'						=> '',

		    	// Dribbble
		        	'db_token'							=> '',
		        	'db_user_id'						=> '',

		        // Github
		        	'gh_token'							=> '',
		        	'gh_user_id'						=> '',

		        // Envato
		        	'env_token'							=> '',
		        	'env_user_id'						=> '',
		        	'env_site'							=> '',

		        // SoundCloud
		        	'sc_client_id'						=> '',
		        	'sc_user_id'						=> '',

		        // Behance
		        	'be_client_id'						=> '',
		        	'be_user_id'						=> '',

		        // Delicious
		        	'del_user_id'						=> '',

		        // Instagram
		        	'ig_user_id'						=> '',

		        // LinkedIn
		        	'li_user_id'						=> '',

		        // Pinterest
		        	'pi_user_id'						=> '',

		        // Vine
		        	'vi_user_id'						=> '',

		        // Spotify
		        	'si_user_id'						=> '',

		        // Mixcloud
		        	'mix_user_id'						=> '',

		        // Twitch
		        	'twi_user_id'						=> '',

		        // Steam
		        	'stm_user_id'						=> '',

		        // Goodreads
		        	'gr_user_id'						=> '',

		        // VK
		        	'vk_user_id'						=> '',

		        // Tumblr
		        	'tbr_user_id'						=> '',

		        // 500px
		        	'fivepx_user_id'					=> '',

		        // Mailchimp
		        	'mc_user_id'						=> '',

		        // Blog Posts
		        	'posts'								=> '',

		        // Comments
		        	'comments'							=> '',

		        // Users
		        	'users'								=> '',

		        // RSS
		        	'rss_count'							=> '',
		        	'rss_url'							=> '',

		        // Only for Back-end purposes
		        	'post_id'							=> '',
		        	'status'							=> ''

			), $atts ) );

	    	// global $post;
	    	global $btnsx_settings;

			// $post_id = $post_id != '' ? $post_id : $post->ID;
			// $post_title = get_the_title( $post_id );

			// $url = $url != '' ? $url : $_SERVER['REQUEST_URI'];
			// $md5 = md5( $url );

			$order = $order != '' ? $order : $this->meta_values( $id, array( 'field' => 'btnsx_order' ) );
			$theme = $theme != '' ? $theme : $this->meta_values( $id, array( 'field' => 'btnsx_theme', 'value' => 'theme1' ) );

			if( $order != '' ){
				$order = explode(',', $order);
				$order_status = array();
				// Set status
				foreach ($order as $v) {
					$v = explode(':',$v);
					$order_status[$v[0]] = $v[1];
				}
			} else {
				$order = array();
				$order_status = array();
			}

			// Variables.
				$fb_app_id = ( $fb_app_id != '' ) ? $fb_app_id : isset( $btnsx_settings['social_counters_fb_app_id'] ) && $btnsx_settings['social_counters_fb_app_id'] != '' ? $btnsx_settings['social_counters_fb_app_id'] : '';

				$fb_page_id = ( $fb_page_id != '' ) ? $fb_page_id : isset( $btnsx_settings['social_counters_fb_page_id'] ) && $btnsx_settings['social_counters_fb_page_id'] != '' ? $btnsx_settings['social_counters_fb_page_id'] : '';

				$tw_username = ( $tw_username != '' ) ? $tw_username : isset( $btnsx_settings['social_counters_tw_username'] ) && $btnsx_settings['social_counters_tw_username'] != '' ? $btnsx_settings['social_counters_tw_username'] : '';

				$gp_page_id = ( $gp_page_id != '' ) ? $gp_page_id : isset( $btnsx_settings['social_counters_gp_page_id'] ) && $btnsx_settings['social_counters_gp_page_id'] != '' ? $btnsx_settings['social_counters_gp_page_id'] : '';

				$yt_app_id = ( $yt_app_id != '' ) ? $yt_app_id : isset( $btnsx_settings['social_counters_yt_app_id'] ) && $btnsx_settings['social_counters_yt_app_id'] != '' ? $btnsx_settings['social_counters_yt_app_id'] : '';
				$yt_channel_id = ( $yt_channel_id != '' ) ? $yt_channel_id : isset( $btnsx_settings['social_counters_yt_channel_id'] ) && $btnsx_settings['social_counters_yt_channel_id'] != '' ? $btnsx_settings['social_counters_yt_channel_id'] : '';

				$vm_app_id = ( $vm_app_id != '' ) ? $vm_app_id : isset( $btnsx_settings['social_counters_vm_app_id'] ) && $btnsx_settings['social_counters_vm_app_id'] != '' ? $btnsx_settings['social_counters_vm_app_id'] : '';
				$vm_channel_id = ( $vm_channel_id != '' ) ? $vm_channel_id : isset( $btnsx_settings['social_counters_vm_channel_id'] ) && $btnsx_settings['social_counters_vm_channel_id'] != '' ? $btnsx_settings['social_counters_vm_channel_id'] : '';

				$db_token = ( $db_token != '' ) ? $db_token : isset( $btnsx_settings['social_counters_db_token'] ) && $btnsx_settings['social_counters_db_token'] != '' ? $btnsx_settings['social_counters_db_token'] : '';
				$db_user_id = ( $db_user_id != '' ) ? $db_user_id : isset( $btnsx_settings['social_counters_db_user_id'] ) && $btnsx_settings['social_counters_db_user_id'] != '' ? $btnsx_settings['social_counters_db_user_id'] : '';

				$gh_user_id = ( $gh_user_id != '' ) ? $gh_user_id : isset( $btnsx_settings['social_counters_gh_user_id'] ) && $btnsx_settings['social_counters_gh_user_id'] != '' ? $btnsx_settings['social_counters_gh_user_id'] : '';

				$env_site = ( $env_site != '' ) ? $env_site : isset( $btnsx_settings['social_counters_env_site'] ) && $btnsx_settings['social_counters_env_site'] != '' ? $btnsx_settings['social_counters_env_site'] : 'themeforest.net';
				$env_user_id = ( $env_user_id != '' ) ? $env_user_id : isset( $btnsx_settings['social_counters_env_user_id'] ) && $btnsx_settings['social_counters_env_user_id'] != '' ? $btnsx_settings['social_counters_env_user_id'] : '';

				$sc_user_id = ( $sc_user_id != '' ) ? $sc_user_id : isset( $btnsx_settings['social_counters_sc_user_id'] ) && $btnsx_settings['social_counters_sc_user_id'] != '' ? $btnsx_settings['social_counters_sc_user_id'] : '';

				$be_user_id = ( $be_user_id != '' ) ? $be_user_id : isset( $btnsx_settings['social_counters_be_user_id'] ) && $btnsx_settings['social_counters_be_user_id'] != '' ? $btnsx_settings['social_counters_be_user_id'] : '';

				$del_user_id = ( $del_user_id != '' ) ? $del_user_id : isset( $btnsx_settings['social_counters_del_user_id'] ) && $btnsx_settings['social_counters_del_user_id'] != '' ? $btnsx_settings['social_counters_del_user_id'] : '';

				$ig_user_id = ( $ig_user_id != '' ) ? $ig_user_id : isset( $btnsx_settings['social_counters_ig_user_id'] ) && $btnsx_settings['social_counters_ig_user_id'] != '' ? $btnsx_settings['social_counters_ig_user_id'] : '';

				$li_user_id = ( $li_user_id != '' ) ? $li_user_id : isset( $btnsx_settings['social_counters_li_user_id'] ) && $btnsx_settings['social_counters_li_user_id'] != '' ? $btnsx_settings['social_counters_li_user_id'] : '';

				$pi_user_id = ( $pi_user_id != '' ) ? $pi_user_id : isset( $btnsx_settings['social_counters_pi_user_id'] ) && $btnsx_settings['social_counters_pi_user_id'] != '' ? $btnsx_settings['social_counters_pi_user_id'] : '';

				$vi_user_id = ( $vi_user_id != '' ) ? $vi_user_id : isset( $btnsx_settings['social_counters_vi_user_id'] ) && $btnsx_settings['social_counters_vi_user_id'] != '' ? $btnsx_settings['social_counters_vi_user_id'] : '';

				$si_user_id = ( $si_user_id != '' ) ? $si_user_id : isset( $btnsx_settings['social_counters_si_user_id'] ) && $btnsx_settings['social_counters_si_user_id'] != '' ? $btnsx_settings['social_counters_si_user_id'] : '';
				$si_user_type = isset( $btnsx_settings['social_counters_si_user_type'] ) && $btnsx_settings['social_counters_si_user_type'] != '' ? $btnsx_settings['social_counters_si_user_type'] : 'user';

				$mix_user_id = ( $mix_user_id != '' ) ? $mix_user_id : isset( $btnsx_settings['social_counters_mix_user_id'] ) && $btnsx_settings['social_counters_mix_user_id'] != '' ? $btnsx_settings['social_counters_mix_user_id'] : '';

				$twi_user_id = ( $twi_user_id != '' ) ? $twi_user_id : isset( $btnsx_settings['social_counters_twi_user_id'] ) && $btnsx_settings['social_counters_twi_user_id'] != '' ? $btnsx_settings['social_counters_twi_user_id'] : '';

				$stm_user_id = ( $stm_user_id != '' ) ? $stm_user_id : isset( $btnsx_settings['social_counters_stm_user_id'] ) && $btnsx_settings['social_counters_stm_user_id'] != '' ? $btnsx_settings['social_counters_stm_user_id'] : '';

				$gr_user_id = ( $gr_user_id != '' ) ? $gr_user_id : isset( $btnsx_settings['social_counters_gr_user_id'] ) && $btnsx_settings['social_counters_gr_user_id'] != '' ? $btnsx_settings['social_counters_gr_user_id'] : '';

				$vk_user_id = ( $vk_user_id != '' ) ? $vk_user_id : isset( $btnsx_settings['social_counters_vk_user_id'] ) && $btnsx_settings['social_counters_vk_user_id'] != '' ? $btnsx_settings['social_counters_vk_user_id'] : '';

				$tbr_user_id = ( $tbr_user_id != '' ) ? $tbr_user_id : isset( $btnsx_settings['social_counters_tbr_user_id'] ) && $btnsx_settings['social_counters_tbr_user_id'] != '' ? $btnsx_settings['social_counters_tbr_user_id'] : '';

				$fivepx_user_id = ( $fivepx_user_id != '' ) ? $fivepx_user_id : isset( $btnsx_settings['social_counters_fivepx_user_id'] ) && $btnsx_settings['social_counters_fivepx_user_id'] != '' ? $btnsx_settings['social_counters_fivepx_user_id'] : '';

				$mc_user_id = ( $mc_user_id != '' ) ? $mc_user_id : isset( $btnsx_settings['social_counters_mc_list_id'] ) && $btnsx_settings['social_counters_mc_list_id'] != '' ? $btnsx_settings['social_counters_mc_list_id'] : isset( $btnsx_settings['social_counters_mc_api_key'] ) && $btnsx_settings['social_counters_mc_api_key'] != '' ? $btnsx_settings['social_counters_mc_api_key'] : '';

				$rss_count = ( $rss_count != '' ) ? $rss_count : isset( $btnsx_settings['social_counters_rss_count'] ) && $btnsx_settings['social_counters_rss_count'] != '' ? $btnsx_settings['social_counters_rss_count'] : 0;
				$rss_url = ( $rss_url != '' ) ? $rss_url : isset( $btnsx_settings['social_counters_rss_url'] ) && $btnsx_settings['social_counters_rss_url'] != '' ? $btnsx_settings['social_counters_rss_url'] : '#';

				$md5_posts = md5('btnsx_scposts');
				$posts_trans = get_transient( 'btnsx_scposts_' . $md5_posts );
	        	if ( false === $posts_trans ) {
	        		delete_transient( 'btnsx_scposts_' . $md5_posts );
					if( function_exists('wp_count_posts') ){
						$posts = ( $posts != '' ) ? $posts : $this->nice_number( wp_count_posts()->publish );
					}else{
						$posts = 0;
					}
	        		set_transient( 'btnsx_scposts_' . $md5_posts, $posts, $this->cache ); // 24 hours
			 	} else {
			 		$posts = get_transient( 'btnsx_scposts_' . $md5_posts );
			 	}

			 	$md5_comments = md5('btnsx_sccom');
			 	delete_transient( 'btnsx_sccom_' . $md5_comments );
				$comments_trans = get_transient( 'btnsx_sccom_' . $md5_comments );
	        	if ( false === $comments_trans ) {
	        		delete_transient( 'btnsx_sccom_' . $md5_comments );
					if( function_exists('wp_count_comments') ){
						$comments = ( $comments != '' ) ? $comments : $this->nice_number( wp_count_comments()->approved );
					}else{
						$comments = 0;
					}
	        		set_transient( 'btnsx_sccom_' . $md5_comments, $comments, $this->cache ); // 24 hours
			 	} else {
			 		$comments = get_transient( 'btnsx_sccom_' . $md5_comments );
			 	}

				$md5_users = md5('btnsx_scuser');
				delete_transient( 'btnsx_scuser_' . $md5_users );
				$users_trans = get_transient( 'btnsx_scuser_' . $md5_users );
	        	if ( false === $users_trans ) {
	        		delete_transient( 'btnsx_scuser_' . $md5_users );
					if( function_exists('count_users') ){
						$users = ( $users != '' ) ? $users : count_users();
						$total_users = $this->nice_number( $users['total_users'] );
					}else{
						$total_users = 0;
					}
	        		set_transient( 'btnsx_scuser_' . $md5_users, $total_users, $this->cache ); // 24 hours
			 	} else {
			 		$total_users = get_transient( 'btnsx_scuser_' . $md5_users );
			 	}

			// Counts
				if( isset( $order_status['facebook'] ) && $order_status['facebook'] == '1' ){
					$nice_likes = $this->nice_number( $this->get_likes( md5($fb_page_id), $id, $fb_page_id ) );
				}else{
					$nice_likes = 0;
				}
				if( isset( $order_status['twitter'] ) && $order_status['twitter'] == '1' ){
					$nice_tweets = $this->nice_number( $this->get_tweets( md5($tw_username), $id, $tw_username ) );
				}else{
					$nice_tweets = 0;
				}
				if( isset( $order_status['googleplus'] ) && $order_status['googleplus'] == '1' ){
					$nice_plusones = $this->nice_number( $this->get_plusones( md5($gp_page_id), $id, $gp_page_id ) );
				}else{
					$nice_plusones = 0;
				}
					// $nice_stumbles = '255.2k'; // need work
				if( isset( $order_status['youtube'] ) && $order_status['youtube'] == '1' ){
					$nice_yt_count = $this->nice_number( $this->get_yt_subscribers( md5($yt_channel_id), $id, $yt_channel_id ) );
				}else{
					$nice_yt_count = 0;
				}
				if( isset( $order_status['vimeo'] ) && $order_status['vimeo'] == '1' ){
					$nice_vm_count = $this->nice_number( $this->get_vm_subscribers( md5($vm_channel_id), $id, $vm_channel_id ) );
				}else{
					$nice_vm_count = 0;
				}
				if( isset( $order_status['dribbble'] ) && $order_status['dribbble'] == '1' ){
					$nice_db_count = $this->nice_number( $this->get_db_followers( md5($db_user_id), $id, $db_user_id ) );
				}else{
					$nice_db_count = 0;
				}
				if( isset( $order_status['github'] ) && $order_status['github'] == '1' ){
					$nice_gh_count = $this->nice_number( $this->get_gh_followers( md5($gh_user_id), $id, $gh_user_id ) );
				}else{
					$nice_gh_count = 0;
				}
				if( isset( $order_status['envato'] ) && $order_status['envato'] == '1' ){
					$nice_env_count = $this->nice_number( $this->get_env_followers( md5($env_user_id), $id, $env_user_id ) );
				}else{
					$nice_env_count = 0;
				}
				if( isset( $order_status['soundcloud'] ) && $order_status['soundcloud'] == '1' ){
					$nice_sc_count = $this->nice_number( $this->get_sc_followers( md5($sc_user_id), $id, $sc_user_id ) );
				}else{
					$nice_sc_count = 0;
				}
				if( isset( $order_status['behance'] ) && $order_status['behance'] == '1' ){
					$nice_be_count = $this->nice_number( $this->get_be_followers( md5($be_user_id), $id, $be_user_id ) );
				}else{
					$nice_be_count = 0;
				}
				if( isset( $order_status['delicious'] ) && $order_status['delicious'] == '1' ){
					$nice_del_count = $this->nice_number( $this->get_del_followers( md5($del_user_id), $id, $del_user_id ) );
				}else{
					$nice_del_count = 0;
				}
				if( isset( $order_status['instagram'] ) && $order_status['instagram'] == '1' ){
					$nice_ig_count = $this->nice_number( $this->get_ig_followers( md5($ig_user_id), $id, $ig_user_id ) );
				}else{
					$nice_ig_count = 0;
				}
				if( isset( $order_status['linkedin'] ) && $order_status['linkedin'] == '1' ){
					$nice_li_count = $this->nice_number( $this->get_li_followers( md5($li_user_id), $id, $li_user_id ) );
				}else{
					$nice_li_count = 0;
				}
				if( isset( $order_status['pinterest'] ) && $order_status['pinterest'] == '1' ){
					$nice_pi_count = $this->nice_number( $this->get_pi_followers( md5($pi_user_id), $id, $pi_user_id ) );
				}else{
					$nice_pi_count = 0;
				}
				if( isset( $order_status['vine'] ) && $order_status['vine'] == '1' ){
					$nice_vi_count = $this->nice_number( $this->get_vi_followers( md5($vi_user_id), $id, $vi_user_id ) );
				}else{
					$nice_vi_count = 0;
				}
				if( isset( $order_status['spotify'] ) && $order_status['spotify'] == '1' ){
					$nice_si_count = $this->nice_number( $this->get_si_followers( md5($si_user_id), $id, $si_user_id ) );
				}else{
					$nice_si_count = 0;
				}
				if( isset( $order_status['mixcloud'] ) && $order_status['mixcloud'] == '1' ){
					$nice_mix_count = $this->nice_number( $this->get_mix_followers( md5($mix_user_id), $id, $mix_user_id ) );
				}else{
					$nice_mix_count = 0;
				}
				if( isset( $order_status['twitch'] ) && $order_status['twitch'] == '1' ){
					$nice_twi_count = $this->nice_number( $this->get_twi_followers( md5($twi_user_id), $id, $twi_user_id ) );
				}else{
					$nice_twi_count = 0;
				}
				if( isset( $order_status['steam'] ) && $order_status['steam'] == '1' ){
					$nice_stm_count = $this->nice_number( $this->get_stm_followers( md5($stm_user_id), $id, $stm_user_id ) );
				}else{
					$nice_stm_count = 0;
				}
				if( isset( $order_status['goodreads'] ) && $order_status['goodreads'] == '1' ){
					$nice_gr_count = $this->nice_number( $this->get_gr_followers( md5($gr_user_id), $id, $gr_user_id ) );
				}else{
					$nice_gr_count = 0;
				}
				if( isset( $order_status['vk'] ) && $order_status['vk'] == '1' ){
					$nice_vk_count = $this->nice_number( $this->get_vk_followers( md5($vk_user_id), $id, $vk_user_id ) );
				}else{
					$nice_vk_count = 0;
				}
				if( isset( $order_status['tumblr'] ) && $order_status['tumblr'] == '1' ){
					$nice_tbr_count = $this->nice_number( $this->get_tbr_followers( md5($tbr_user_id), $id, $tbr_user_id ) );
					// var_dump($nice_tbr_count);
				}else{
					$nice_tbr_count = 0;
				}
				if( isset( $order_status['500px'] ) && $order_status['500px'] == '1' ){
					$nice_fivepx_count = $this->nice_number( $this->get_fivepx_followers( md5($fivepx_user_id), $id, $fivepx_user_id ) );
				}else{
					$nice_fivepx_count = 0;
				}
				if( isset( $order_status['mailchimp'] ) && $order_status['mailchimp'] == '1' ){
					$nice_mc_count = $this->nice_number( $this->get_mc_followers( md5($mc_user_id), $id, $mc_user_id ) );
				}else{
					$nice_mc_count = 0;
				}

				$total = (int) $likes + (int) $tweets + (int) $plusones + (int) $stumbles;
				$nice_total = $total;

			// Share Buttons
				// $fb_btn_share = '<a class="post-share facebook" href="http://www.facebook.com/plugins/like.php?href='.$url.'&width&layout=standard&action=like&show_faces=true&share=true&height=80&appId='.$fb_app_id.'" onclick="javascript:window.open(this.href, \'\', \'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=100,width=200\');return false;">Facebook<span>'.$nice_likes.'</span></a>';

				// $tw_btn_share = '<a class="post-share twitter" href="https://twitter.com/share?url='.$url.'&text='.$post_title.'&via='.$tw_username.'" onclick="javascript:window.open(this.href, \'\', \'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600\');return false;">Twitter<span>'.$nice_tweets.'</span></a>';

				// $gp_btn_share = '<a class="post-share gplus" href="https://plus.google.com/share?url='.$url.'" onclick="javascript:window.open(this.href, \'\', \'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600\');return false;">Google Plus<span>'.$nice_plusones.'</span></a>';

				// $su_btn_share = '<a class="post-share stumble" href="http://www.stumbleupon.com/submit?url='.$url.'" onclick="javascript:window.open(this.href, \'\', \'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=800\');return false;">Stumbleupon<span>'.$nice_stumbles.'</span></a>';

			// Follow Buttons
				$fb_btn_follow = apply_filters( 'btnsx_sc_fb_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-facebook" target="_blank" href="https://www.facebook.com/'.$fb_page_id.'/"><span class="fab fa-facebook btnsx-sc-icon"></span><span class="btnsx-sc-text">Facebook</span><span class="btnsx-sc-count">'.$nice_likes.'</span></a>', $fb_page_id, $nice_likes );

				$tw_btn_follow = apply_filters( 'btnsx_sc_tw_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-twitter" target="_blank" href="https://twitter.com/'.$tw_username.'"><span class="fab fa-twitter btnsx-sc-icon"></span><span class="btnsx-sc-text">Twitter</span><span class="btnsx-sc-count">'.$nice_tweets.'</span></a>', $tw_username, $nice_tweets );

				$gp_btn_follow = apply_filters( 'btnsx_sc_gp_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-gplus" target="_blank" href="https://plus.google.com/'.$gp_page_id.'"><span class="fab fa-google-plus btnsx-sc-icon"></span><span class="btnsx-sc-text">Google+</span><span class="btnsx-sc-count">'.$nice_plusones.'</span></a>', $gp_page_id, $nice_plusones );

				$yt_btn_follow = apply_filters( 'btnsx_sc_yt_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-youtube" target="_blank" href="http://youtube.com/channel/'.$yt_channel_id.'/"><span class="fab fa-youtube btnsx-sc-icon"></span><span class="btnsx-sc-text">Youtube</span><span class="btnsx-sc-count">'.$nice_yt_count.'</span></a>', $yt_channel_id, $nice_yt_count );

				$vm_btn_follow = apply_filters( 'btnsx_sc_vm_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-vimeo" target="_blank" href="https://vimeo.com/channels/'.$vm_channel_id.'/"><span class="fab fa-vimeo btnsx-sc-icon"></span><span class="btnsx-sc-text">Vimeo</span><span class="btnsx-sc-count">'.$nice_vm_count.'</span></a>', $vm_channel_id, $nice_vm_count);

				$db_btn_follow = apply_filters( 'btnsx_sc_db_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-dribbble" target="_blank" href="https://dribbble.com/'.$db_user_id.'/"><span class="fab fa-dribbble btnsx-sc-icon"></span><span class="btnsx-sc-text">Dribbble</span><span class="btnsx-sc-count">'.$nice_db_count.'</span></a>', $db_user_id, $nice_db_count );

				$gh_btn_follow = apply_filters( 'btnsx_sc_gh_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-github" target="_blank" href="https://github.com/'.$gh_user_id.'/"><span class="fab fa-github btnsx-sc-icon"></span><span class="btnsx-sc-text">Github</span><span class="btnsx-sc-count">'.$nice_gh_count.'</span></a>', $gh_user_id, $nice_gh_count );

				$env_btn_follow = apply_filters( 'btnsx_sc_env_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-envato" target="_blank" href="http://'.$env_site.'/user/'.$env_user_id.'/"><span class="fab fa-envato btnsx-sc-icon"></span><span class="btnsx-sc-text">Envato</span><span class="btnsx-sc-count">'.$nice_env_count.'</span></a>', $env_user_id, $nice_env_count, $env_site );

				$sc_btn_follow = apply_filters( 'btnsx_sc_sc_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-soundcloud" target="_blank" href="http://soundcloud.com/'.$sc_user_id.'/"><span class="fab fa-soundcloud btnsx-sc-icon"></span>SoundCloud<span class="btnsx-sc-count">'.$nice_sc_count.'</span></a>', $sc_user_id, $nice_sc_count );

				$be_btn_follow = apply_filters( 'btnsx_sc_be_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-behance" target="_blank" href="https://www.behance.net/'.$be_user_id.'/"><span class="fab fa-behance btnsx-sc-icon"></span><span class="btnsx-sc-text">Behance</span><span class="btnsx-sc-count">'.$nice_be_count.'</span></a>', $be_user_id, $nice_be_count );

				$del_btn_follow = apply_filters( 'btnsx_sc_del_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-delicious" target="_blank" href="https://www.delicious.com/'.$del_user_id.'/"><span class="fab fa-delicious btnsx-sc-icon"></span><span class="btnsx-sc-text">Delicious</span><span class="btnsx-sc-count">'.$nice_del_count.'</span></a>', $del_user_id, $nice_del_count );

				$ig_btn_follow = apply_filters( 'btnsx_sc_ig_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-instagram" target="_blank" href="https://www.instagram.com/'.$ig_user_id.'/"><span class="fab fa-instagram btnsx-sc-icon"></span><span class="btnsx-sc-text">Instagram</span><span class="btnsx-sc-count">'.$nice_ig_count.'</span></a>', $ig_user_id, $nice_ig_count );

				$li_btn_follow = apply_filters( 'btnsx_sc_li_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-linkedin" target="_blank" href="'.$li_user_id.'/"><span class="fab fa-linkedin btnsx-sc-icon"></span><span class="btnsx-sc-text">LinkedIn</span><span class="btnsx-sc-count">'.$nice_li_count.'</span></a>', $li_user_id, $nice_li_count );

				$pi_btn_follow = apply_filters( 'btnsx_sc_pi_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-pinterest" target="_blank" href="https://www.pinterest.com/'.$pi_user_id.'/"><span class="fab fa-pinterest btnsx-sc-icon"></span><span class="btnsx-sc-text">Pinterest</span><span class="btnsx-sc-count">'.$nice_pi_count.'</span></a>', $pi_user_id, $nice_pi_count );

				$vi_btn_follow = apply_filters( 'btnsx_sc_vi_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-vine" target="_blank" href="https://vine.co/u/'.$vi_user_id.'/"><span class="fab fa-vine btnsx-sc-icon"></span><span class="btnsx-sc-text">Vine</span><span class="btnsx-sc-count">'.$nice_vi_count.'</span></a>', $vi_user_id, $nice_vi_count );

				$si_btn_follow = apply_filters( 'btnsx_sc_si_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-spotify" target="_blank" href="https://open.spotify.com/'.$si_user_type.'/'.$si_user_id.'/"><span class="fab fa-spotify btnsx-sc-icon"></span><span class="btnsx-sc-text">Spotify</span><span class="btnsx-sc-count">'.$nice_si_count.'</span></a>', $si_user_id, $nice_si_count, $si_user_type );

				$mix_btn_follow = apply_filters( 'btnsx_sc_mix_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-mixcloud" target="_blank" href="https://www.mixcloud.com/'.$mix_user_id.'/"><span class="fab fa-mixcloud btnsx-sc-icon"></span><span class="btnsx-sc-text">Mixcloud</span><span class="btnsx-sc-count">'.$nice_mix_count.'</span></a>', $mix_user_id, $nice_mix_count );

				$twi_btn_follow = apply_filters( 'btnsx_sc_twi_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-twitch" target="_blank" href="https://www.twitch.tv/'.$twi_user_id.'/profile/"><span class="fab fa-twitch btnsx-sc-icon"></span><span class="btnsx-sc-text">Twitch</span><span class="btnsx-sc-count">'.$nice_twi_count.'</span></a>', $twi_user_id, $nice_twi_count );

				$stm_btn_follow = apply_filters( 'btnsx_sc_stm_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-steam" target="_blank" href="http://steamcommunity.com/groups/'.$stm_user_id.'/"><span class="fab fa-steam btnsx-sc-icon"></span><span class="btnsx-sc-text">Steam</span><span class="btnsx-sc-count">'.$nice_stm_count.'</span></a>', $stm_user_id, $nice_stm_count );

				$gr_btn_follow = apply_filters( 'btnsx_sc_gr_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-goodreads" target="_blank" href="https://www.goodreads.com/author/show/'.$gr_user_id.'"><span class="fab fa-goodreads btnsx-sc-icon"></span><span class="btnsx-sc-text">Goodreads</span><span class="btnsx-sc-count">'.$nice_gr_count.'</span></a>', $gr_user_id, $nice_gr_count );

				$vk_btn_follow = apply_filters( 'btnsx_sc_vk_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-vk" target="_blank" href="https://vk.com/'.$vk_user_id.'"><span class="fab fa-vk btnsx-sc-icon"></span><span class="btnsx-sc-text">VKontakte</span><span class="btnsx-sc-count">'.$nice_vk_count.'</span></a>', $vk_user_id, $nice_vk_count );

				$tbr_btn_follow = apply_filters( 'btnsx_sc_tbr_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-tumblr" target="_blank" href="http://'.$tbr_user_id.'/"><span class="fab fa-tumblr btnsx-sc-icon"></span><span class="btnsx-sc-text">Tumblr</span><span class="btnsx-sc-count">'.$nice_tbr_count.'</span></a>', $tbr_user_id, $nice_tbr_count );

				$fivepx_btn_follow = apply_filters( 'btnsx_sc_tbr_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-fivepx" target="_blank" href="http://500px.com/'.$fivepx_user_id.'/"><span class="fab fa-500px btnsx-sc-icon"></span><span class="btnsx-sc-text">500px</span><span class="btnsx-sc-count">'.$nice_fivepx_count.'</span></a>', $fivepx_user_id, $nice_fivepx_count );

				$mc_btn_follow = apply_filters( 'btnsx_sc_tbr_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-mailchimp" target="_blank" href="'.$this->mc_list_url.'"><span class="fas fa-envelope btnsx-sc-icon"></span><span class="btnsx-sc-text">Subscribers</span><span class="btnsx-sc-count">'.$nice_mc_count.'</span></a>', $this->mc_list_url, $nice_mc_count );

				$posts_btn_follow = apply_filters( 'btnsx_sc_tbr_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-posts" target="_blank" href="#"><span class="fas fa-file-alt btnsx-sc-icon"></span><span class="btnsx-sc-text">' . __( 'Posts', 'btnsx' ) . '</span><span class="btnsx-sc-count">'.$posts.'</span></a>', $posts );

				$comments_btn_follow = apply_filters( 'btnsx_sc_tbr_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-comments" target="_blank" href="#"><span class="fas fa-comments btnsx-sc-icon"></span><span class="btnsx-sc-text">' . __( 'Comments', 'btnsx' ) . '</span><span class="btnsx-sc-count">'.$comments.'</span></a>', $comments );

				$users_btn_follow = apply_filters( 'btnsx_sc_tbr_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-users" target="_blank" href="#"><span class="fas fa-users btnsx-sc-icon"></span>' . __( 'Users', 'btnsx' ) . '<span class="btnsx-sc-count">'.$total_users.'</span></a>', $total_users );

				$rss_btn_follow = apply_filters( 'btnsx_sc_tbr_btn', '<a class="btnsx-follow btnsx-follow-'.$theme.' btnsx-rss" target="_blank" href="'.$rss_url.'"><span class="fas fa-rss btnsx-sc-icon"></span><span class="btnsx-sc-text">' . __( 'RSS', 'btnsx' ) . '</span><span class="btnsx-sc-count">'.$this->nice_number($rss_count).'</span></a>', $rss_url, $this->nice_number($rss_count) );

			// Default Order
				$default_order = array( 
					'500px'	=>	$fivepx_btn_follow,
			    	'behance'	=>	$be_btn_follow,
			    	'comments'	=>	$comments_btn_follow,
			    	'delicious'	=>	$del_btn_follow,
			    	'dribbble'	=>	$db_btn_follow,
			    	'envato'	=>	$env_btn_follow,
			    	'facebook'	=>	$fb_btn_follow,
			    	'github'	=>	$gh_btn_follow,
			    	'goodreads'	=>	$gr_btn_follow,
			    	'googleplus'	=>	$gp_btn_follow,
			    	'instagram'	=>	$ig_btn_follow,
			    	'linkedin'	=>	$li_btn_follow,
			    	'mailchimp'	=>	$mc_btn_follow,
			    	'mixcloud'	=>	$mix_btn_follow,
			    	'pinterest'	=>	$pi_btn_follow,
			    	'posts'	=>	$posts_btn_follow,
			    	'rss'	=>	$rss_btn_follow,
			    	'soundcloud'	=>	$sc_btn_follow,
			    	'spotify'	=>	$si_btn_follow,
			    	'steam'	=>	$stm_btn_follow,
			    	'tumblr'	=>	$tbr_btn_follow,
			    	'twitch'	=>	$twi_btn_follow,
			    	'twitter'	=>	$tw_btn_follow,
			    	'users'	=>	$users_btn_follow,
			    	'vimeo'	=>	$vm_btn_follow,
			    	'vine'	=>	$vi_btn_follow,
			    	'vk'	=>	$vk_btn_follow,
			    	'youtube'	=>	$yt_btn_follow
				);

				// var_dump( $default_order );

			if( $order != ''  ){
				$sorted_order = $this->order_sort( $order, $default_order );
			}else{
				$sorted_order = array();
			}

			$sorted_order = array_filter( $sorted_order );

			if( !empty( $sorted_order ) ){
				$final_order = $sorted_order;
			} else {
				$final_order = '';
			}

			// var_dump($final_order);

			$btns = '';
			if( $final_order != '' ){
				foreach ( $final_order as $key => $value ) {
					$btns .= $value;
				}
			}else{
				$btns = '';
			}

			return 
			'
			<!-- Buttons X - Social Counter - Start -->
			<div id="'.$id.'" class="btnsx-social-counter" style="display: block;overflow: auto;width: 100%">
	        	'.$btns.'
			</div>
			<!-- Buttons X - Social Counter - End -->
			';
	    }

	    /**
	     * Sort counters
	     * @since  1.7.5
	     * @param  array    $a  new order
	     * @param  array    $b  default order
	     * @return array
	     */
	    public function order_sort( $a, $b ) {
	    	$order = array();
		    foreach( $a as $k ) {
		    	$v = explode(':',$k);
		        if( array_key_exists( $v[0], $b ) ) {
		        	if( $v[1] === '1' ){
			            $order[ $v[0] ] = $b[ $v[0] ];
			        }
			        unset( $b[ $v[0] ] );
		        }
		    }
		    return $order;
	    }

		/**
	     * Custom columns on list page
	     * @since  0.1
	     * @param  array    $defaults
	     * @return array
	     */
	    public function columns( $defaults ) {
			$defaults['btnsx_shortcode'] 	= __( 'Shortcode', 'btnsx' );
		    $defaults['btnsx_preview'] 	= __( 'Preview', 'btnsx' );
		    unset( $defaults['date'] );
		    return $defaults;
		}

		/**
		 * Function to remove view link to row actions on buttons X post type
		 * @since  0.1
		 * @param  string    $actions default actions
		 * @param  WP_Post   $post post object
		 * @return string
		 */
		public function row_actions( $actions, WP_Post $post ) {
	        if ( $post->post_type != 'buttons-x-cs' ) {
	            return $actions;
	        }
	        unset( $actions['view'] );
	        return $actions;
	    }

		/**
         * Button update messages.
         * @since  0.1
         * @param  array    $messages
         * @return array
         */
		public function updated_messages( $messages ) {
			$post             = get_post();
			$post_type        = get_post_type( $post );
			$post_type_object = get_post_type_object( $post_type );
			$messages['buttons-x-cs'] = array(
				0  => '', // Unused. Messages start at index 1.
				1  => __( 'Social counter updated.', 'btnsx' ),
				2  => __( 'Custom field updated.', 'btnsx' ),
				3  => __( 'Custom field deleted.', 'btnsx' ),
				4  => __( 'Social counter updated.', 'btnsx' ),
				/* translators: %s: date and time of the revision */
				5  => isset( $_GET['revision'] ) ? sprintf( __( 'Social counter restored to revision from %s', 'btnsx' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
				6  => __( 'Social counter published.', 'btnsx' ),
				7  => __( 'Social counter saved.', 'btnsx' ),
				8  => __( 'Social counter submitted.', 'btnsx' ),
				9  => sprintf(
					__( 'Social counter scheduled for: <strong>%1$s</strong>.', 'btnsx' ),
					// translators: Publish box date format, see http://php.net/date
					date_i18n( __( 'M j, Y @ G:i', 'btnsx' ), strtotime( $post->post_date ) )
				),
				10 => __( 'Social counter draft updated.', 'btnsx' )
			);

			return $messages;
		}

		/**
	     * When the post is saved, saves our custom data.
	     * @param int $post->ID_id The ID of the post being saved.
	     * @since 0.1
	     */
	    public function save_data( $post_id ) {

	        // Check if our nonce is set.
	        if ( !isset( $_POST[ 'btnsx_options_nonce' ] ) ) {
	            return;
	        }

	        // Verify that the nonce is valid.
	        if ( !wp_verify_nonce( $_POST[ 'btnsx_options_nonce' ], 'btnsx-cs' ) ) {
	            return;
	        }

	        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
	        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
	            return;
	        }

	        // Check the user's permissions.
	        if ( isset( $_POST[ 'post_type' ] ) && 'page' == $_POST[ 'post_type' ] ) {
	            if ( !current_user_can( 'edit_page', $post_id ) ) {
	                return;
	            }
	        } else {
	            if ( !current_user_can( 'edit_post', $post_id ) ) {
	                return;
	            }
	        }

	        /* OK, its safe for us to save the data now. */

	        $btnsx_data = array();

	        // Sanitize user input.
	        $btnsx_data = array(
	        	// General
		        	'btnsx_id' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_id'] ) ? $_POST['btnsx_opt_id'] : '' ),
		        	'btnsx_order' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_order'] ) ? $_POST['btnsx_opt_order'] : '' ),
		        	'btnsx_theme' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_theme'] ) ? $_POST['btnsx_opt_theme'] : '' ),
		        	'btnsx_facebook' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_facebook'] ) ? $_POST['btnsx_opt_facebook'] : '' ),
		        	'btnsx_twitter' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_twitter'] ) ? $_POST['btnsx_opt_twitter'] : '' ),
		        	'btnsx_googleplus' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_googleplus'] ) ? $_POST['btnsx_opt_googleplus'] : '' ),
		        	// 'btnsx_stumbleupon' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_stumbleupon'] ) ? $_POST['btnsx_opt_stumbleupon'] : '' ),
		        	'btnsx_youtube' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_youtube'] ) ? $_POST['btnsx_opt_youtube'] : '' ),
		        	'btnsx_vimeo' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_vimeo'] ) ? $_POST['btnsx_opt_vimeo'] : '' ),
		        	'btnsx_dribbble' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_dribbble'] ) ? $_POST['btnsx_opt_dribbble'] : '' ),
		        	'btnsx_github' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_github'] ) ? $_POST['btnsx_opt_github'] : '' ),
		        	'btnsx_envato' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_envato'] ) ? $_POST['btnsx_opt_envato'] : '' ),
		        	'btnsx_soundcloud' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_soundcloud'] ) ? $_POST['btnsx_opt_soundcloud'] : '' ),
		        	'btnsx_behance' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_behance'] ) ? $_POST['btnsx_opt_behance'] : '' ),
		        	'btnsx_delicious' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_delicious'] ) ? $_POST['btnsx_opt_delicious'] : '' ),
		        	'btnsx_instagram' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_instagram'] ) ? $_POST['btnsx_opt_instagram'] : '' ),
		        	'btnsx_linkedin' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_linkedin'] ) ? $_POST['btnsx_opt_linkedin'] : '' ),
		        	'btnsx_pinterest' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_pinterest'] ) ? $_POST['btnsx_opt_pinterest'] : '' ),
		        	'btnsx_vine' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_vine'] ) ? $_POST['btnsx_opt_vine'] : '' ),
		        	'btnsx_spotify' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_spotify'] ) ? $_POST['btnsx_opt_spotify'] : '' ),
		        	'btnsx_mixcloud' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_mixcloud'] ) ? $_POST['btnsx_opt_mixcloud'] : '' ),
		        	'btnsx_twitch' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_twitch'] ) ? $_POST['btnsx_opt_twitch'] : '' ),
		        	'btnsx_steam' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_steam'] ) ? $_POST['btnsx_opt_steam'] : '' ),
		        	'btnsx_goodreads' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_goodreads'] ) ? $_POST['btnsx_opt_goodreads'] : '' ),
		        	'btnsx_vk' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_vk'] ) ? $_POST['btnsx_opt_vk'] : '' ),
		        	'btnsx_tumblr' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_tumblr'] ) ? $_POST['btnsx_opt_tumblr'] : '' ),
		        	'btnsx_500px' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_500px'] ) ? $_POST['btnsx_opt_500px'] : '' ),
		        	'btnsx_mailchimp' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_mailchimp'] ) ? $_POST['btnsx_opt_mailchimp'] : '' ),
		        	'btnsx_posts' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_posts'] ) ? $_POST['btnsx_opt_posts'] : '' ),
		        	'btnsx_comments' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_comments'] ) ? $_POST['btnsx_opt_comments'] : '' ),
		        	'btnsx_users' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_users'] ) ? $_POST['btnsx_opt_users'] : '' ),
		        	'btnsx_rss' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_rss'] ) ? $_POST['btnsx_opt_rss'] : '' )

	        );

	        // Update the meta field in the database.
	        update_post_meta( $post_id, 'btnsx-cs', $btnsx_data );
	    }

	    /**
		 * Fetch meta values
		 * @since  1.7.5
		 * @param  int   	$post_id ID for the current post/page.
		 * @param  array    $params 
		 * @return string
		 */
		public function meta_values( $post_id, $params = array( 'field' => '', 'field2' => '', 'value' => '' ) ) {
			/*
	         * Use get_post_meta() to retrieve an existing value
	         * from the database and use the value for the form.
	         */
	        $meta_values = array();
	        $meta_values = get_post_meta( $post_id, 'btnsx-cs', true );

	        // meta key value
	        $field = isset( $params['field'] ) ? $params['field'] : '';
	        // meta key value in case stored as an array
	        $field2 = isset( $params['field2'] ) ? $params['field2'] : '';
	        // value in case meta value is not defined
	        $value = isset( $params['value'] ) ? $params['value'] : '';

	        // Based on defined parameters set value
	        if ( $field != '' && $field2 == '' ){
	        	$meta_value = isset( $meta_values[$field] ) ? $meta_values[$field] : $value;
	        } elseif ( $field != '' && $field2 != '' ) {
	        	$meta_value = isset( $meta_values[$field][$field2] ) ? $meta_values[$field][$field2] : $value;
	        } else {
	        	$meta_value = '';
	        }

	        return $meta_value;
		}

		/**
		 * Preview inside modal on list page
		 * @since  1.7.5
		 * @param  string    $column_name
		 * @param  int    $id
		 * @return string
		 */
		public function column_preview( $column_name, $id ) {
		    if ( $column_name == 'btnsx_preview' ) {
		        $meta = get_post_meta( $id, 'btnsx-cs', true);
		        ?>
		        <div class="btnsx">
			        <!-- Modal Trigger -->
					<a class="waves-effect waves-light btn modal-trigger" href="#modal<?php echo sanitize_text_field( $id ); ?>"><?php _e( 'Preview', 'btnsx' ); ?></a>
					<!-- Modal Structure -->
					<div id="modal<?php echo $id; ?>" class="modal preview-modal">
					    <div class="modal-content">
					    	<?php 
					    		echo do_shortcode( '[btnsx_social_counter id="'.$id.'"]' );
					    	?>
					    </div>
					    <div class="modal-footer">
					      	<a href="javascript:void(0)" class="modal-action modal-close"><i class="fa fa-close"></i></a>
					    </div>
					</div>
				</div>
				<?php
		        // echo $this->shortcode( array ( 'id' => $id, 'css_inline' => '1' ) );
		    }
		    if ( $column_name == 'btnsx_shortcode' ) {
		        echo '[btnsx_social_counter id="' . sanitize_text_field( $id ) . '"]';
		    }
		}

		/**
		 * Enqueue Public Scripts
		 * @since 1.7.5
		 */
		public function public_enqueue_scripts() {
			wp_enqueue_style(
				'btnsx-social-counter-css',
				BTNSX__PLUGIN_URL . 'assets/css/common/social-counters.css',
				array(),
				BTNSX__VERSION
			);
		}

		/**
		 * Enqueue Admin Scripts
		 * @since 0.1
		 */
		public function admin_enqueue_scripts() {
			$screen = get_current_screen();
			// Admin Scripts
			if ( in_array( $screen->id, array( 'buttons-x-cs', 'edit-buttons-x-cs' ) ) ) {
				wp_enqueue_style(
					'btnsx-social-counter-css',
					BTNSX__PLUGIN_URL . 'assets/css/common/social-counters.css',
					array(),
					BTNSX__VERSION
				);
			}
		}

		/**
		 * remove extra meta boxes on custom post page
		 * @since 0.1
		 */
		public function remove_extra_meta_boxes() {
		    if( get_post_type() == 'buttons-x-cs' ){
		        $meta_boxes_advanced = $this->get_meta_boxes( 'buttons-x-cs', 'advanced' );
		        $meta_boxes_normal = $this->get_meta_boxes( 'buttons-x-cs', 'normal' );
		        $meta_boxes_side = $this->get_meta_boxes( 'buttons-x-cs', 'side' );
		        $meta_advanced = array( '' );
		        $meta_normal = array( 'btnsx-preview', 'btnsx-options' );
		        $meta_side = array( 'submitdiv', 'btnsx_cs_packdiv', 'tagsdiv-btnsx_cs_tag', 'btnsx-shortcode' );
		        foreach ( $meta_boxes_advanced as $key => $value ) {
		            foreach ( $value as $k => $v ) {
		                if( !in_array( $v['id'], $meta_advanced )  ){
		                    remove_meta_box( $v['id'] , 'buttons-x-cs' , 'advanced' );
		                }
		            }
		        }
		        foreach ($meta_boxes_normal as $key => $value) {
		            foreach ($value as $k => $v) {
		                if( !in_array($v['id'], $meta_normal)  ){
		                    remove_meta_box( $v['id'] , 'buttons-x-cs' , 'normal' );
		                }
		            }
		        }
		        foreach ($meta_boxes_side as $key => $value) {
		            foreach ($value as $k => $v) {
		                if( !in_array($v['id'], $meta_side)  ){
		                    remove_meta_box( $v['id'] , 'buttons-x-cs' , 'side' );
		                }
		            }
		        }
		    }
		}

		/**
		 * Extract meta boxes information
		 * @param  string $screen  target page
		 * @param  string $context part of page where meta box is shown
		 * @return array          list of meta boxes on the target page
		 * @since 0.1
		 */
		public function get_meta_boxes( $screen = null, $context = 'advanced' ) {
		    global $wp_meta_boxes;
		    if ( empty( $screen ) ) {
		        $screen = get_current_screen();
		    } elseif ( is_string( $screen ) ) {
		        $screen = convert_to_screen( $screen );
		    }
		    $page = $screen->id;
		    if( isset( $wp_meta_boxes[ $page ][ $context ] ) ) {
		    	return $wp_meta_boxes[ $page ][ $context ];
		    } else {
		    	return array();
		    }
		}

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 0.1
	     */
	    public function shortcode_callback( $post ) {
	    	$current_color = get_user_option( 'admin_color' );
	    	global $_wp_admin_css_colors;
	        echo '<p style="font-weight:bold;color:'.$_wp_admin_css_colors[$current_color]->colors[2].';">[btnsx_social_counter id="'.$post->ID.'"]</p>';
	    }

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 0.1
	     */
	    public function options_callback( $post ) {

	        // Add an nonce field so we can check for it later.
	        wp_nonce_field( 'btnsx-cs', 'btnsx_options_nonce' );

	        /*
	         * Use get_post_meta() to retrieve an existing value
	         * from the database and use the value for the form.
	         */
	        // $meta_values = array();
	        // $meta_values = get_post_meta( $post->ID, 'btnsx-cs', true );

	        echo '<input type="hidden" id="btnsx_opt_order" name="btnsx_opt_order" value="'.$this->meta_values( $post->ID, array( 'field' => 'btnsx_order', 'value' => '' ) ).'">';

	        $elements = array(
	        	'id'	=>	array(
					'type'			=>	'hidden',
					'id'			=>	'btnsx_opt_id',
					'name'			=>	'btnsx_opt_id',
					'label'			=>	__( 'ID', 'btnsx' ),
					'value'			=>	$post->ID
				)
	        );
	        $facebook = array(
				'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_facebook',
			    'name'			=>	'btnsx_opt_facebook',
			    'label'			=>	__( 'Enable Facebook Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Facebook button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_facebook', 'value' => '1' ) )
		    );
		    $twitter = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_twitter',
			    'name'			=>	'btnsx_opt_twitter',
			    'label'			=>	__( 'Enable Twitter Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Twitter button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_twitter', 'value' => '1' ) )
		    );
		    $googleplus = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_googleplus',
			    'name'			=>	'btnsx_opt_googleplus',
			    'label'			=>	__( 'Enable Google+ Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Google+ button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_googleplus', 'value' => '0' ) )
		    );
		    $stumbleupon = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_stumbleupon',
			    'name'			=>	'btnsx_opt_stumbleupon',
			    'label'			=>	__( 'Enable StumbleUpon Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables stumbleUpon button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_stumbleupon', 'value' => '0' ) )
		    );
		    $youtube = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_youtube',
			    'name'			=>	'btnsx_opt_youtube',
			    'label'			=>	__( 'Enable Youtube Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Youtube button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_youtube', 'value' => '0' ) )
		    );
		    $vimeo = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_vimeo',
			    'name'			=>	'btnsx_opt_vimeo',
			    'label'			=>	__( 'Enable Vimeo Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Vimeo button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_vimeo', 'value' => '0' ) )
		    );
		    $dribbble = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_dribbble',
			    'name'			=>	'btnsx_opt_dribbble',
			    'label'			=>	__( 'Enable Dribbble Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Dribbble button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_dribbble', 'value' => '0' ) )
		    );
		    $github = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_github',
			    'name'			=>	'btnsx_opt_github',
			    'label'			=>	__( 'Enable Github Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Github button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_github', 'value' => '0' ) )
		    );
		    $envato = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_envato',
			    'name'			=>	'btnsx_opt_envato',
			    'label'			=>	__( 'Enable Envato Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables envato button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_envato', 'value' => '0' ) )
		    );
		    $soundcloud = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_soundcloud',
			    'name'			=>	'btnsx_opt_soundcloud',
			    'label'			=>	__( 'Enable SoundCloud Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables SoundCloud Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_soundcloud', 'value' => '0' ) )
		    );
		    $behance = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_behance',
			    'name'			=>	'btnsx_opt_behance',
			    'label'			=>	__( 'Enable Behance Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Behance Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_behance', 'value' => '0' ) )
		    );
		    $delicious = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_delicious',
			    'name'			=>	'btnsx_opt_delicious',
			    'label'			=>	__( 'Enable Delicious Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Delicious Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_delicious', 'value' => '0' ) )
		    );
		    $instagram = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_instagram',
			    'name'			=>	'btnsx_opt_instagram',
			    'label'			=>	__( 'Enable Instagram Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Instagram Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_instagram', 'value' => '0' ) )
		    );
		    $linkedin = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_linkedin',
			    'name'			=>	'btnsx_opt_linkedin',
			    'label'			=>	__( 'Enable Linkedin Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Linkedin Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_linkedin', 'value' => '0' ) )
		    );
		    $pinterest = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_pinterest',
			    'name'			=>	'btnsx_opt_pinterest',
			    'label'			=>	__( 'Enable Pinterest Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Pinterest Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_pinterest', 'value' => '0' ) )
		    );
		    $vine = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_vine',
			    'name'			=>	'btnsx_opt_vine',
			    'label'			=>	__( 'Enable Vine Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Vine Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_vine', 'value' => '0' ) )
		    );
		    $spotify = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_spotify',
			    'name'			=>	'btnsx_opt_spotify',
			    'label'			=>	__( 'Enable Spotify Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Spotify Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_spotify', 'value' => '0' ) )
		    );
		    $mixcloud = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_mixcloud',
			    'name'			=>	'btnsx_opt_mixcloud',
			    'label'			=>	__( 'Enable Mixcloud Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Mixcloud Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_mixcloud', 'value' => '0' ) )
		    );
		    $twitch = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_twitch',
			    'name'			=>	'btnsx_opt_twitch',
			    'label'			=>	__( 'Enable Twitch Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Twitch Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_twitch', 'value' => '0' ) )
		    );
		    $steam = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_steam',
			    'name'			=>	'btnsx_opt_steam',
			    'label'			=>	__( 'Enable Steam Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Steam Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_steam', 'value' => '0' ) )
		    );
		    $goodreads = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_goodreads',
			    'name'			=>	'btnsx_opt_goodreads',
			    'label'			=>	__( 'Enable Goodreads Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Goodreads Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_goodreads', 'value' => '0' ) )
		    );
		    $vk = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_vk',
			    'name'			=>	'btnsx_opt_vk',
			    'label'			=>	__( 'Enable VK Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables VK Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_vk', 'value' => '0' ) )
		    );
		    $tumblr = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_tumblr',
			    'name'			=>	'btnsx_opt_tumblr',
			    'label'			=>	__( 'Enable Tumblr Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Tumblr Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_tumblr', 'value' => '0' ) )
		    );
		    $fivepx = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_500px',
			    'name'			=>	'btnsx_opt_500px',
			    'label'			=>	__( 'Enable 500px Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables 500px Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_500px', 'value' => '0' ) )
		    );
		    $mailchimp = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_mailchimp',
			    'name'			=>	'btnsx_opt_mailchimp',
			    'label'			=>	__( 'Enable Mailchimp Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Mailchimp Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_mailchimp', 'value' => '0' ) )
		    );
		    $posts = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_posts',
			    'name'			=>	'btnsx_opt_posts',
			    'label'			=>	__( 'Enable Posts Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Posts Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_posts', 'value' => '0' ) )
		    );
		    $comments = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_comments',
			    'name'			=>	'btnsx_opt_comments',
			    'label'			=>	__( 'Enable Comments Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Comments Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_comments', 'value' => '0' ) )
		    );
		    $users = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_users',
			    'name'			=>	'btnsx_opt_users',
			    'label'			=>	__( 'Enable Users Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables Users Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_users', 'value' => '0' ) )
		    );
		    $rss = array(
			    'type'			=>	'checkbox',
			    'id'			=>	'btnsx_opt_rss',
			    'name'			=>	'btnsx_opt_rss',
			    'label'			=>	__( 'Enable RSS Button', 'btnsx' ),
			    'tooltip'		=>	__( 'Enables RSS Button.', 'btnsx' ),
			    'class'			=> 'btnsx-checkbox btnsx-checkbox-sortable',
			    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_rss', 'value' => '0' ) )
		    );

		    $default_order = array(
		    	'500px'	=>	$fivepx,
		    	'behance'	=>	$behance,
		    	'comments'	=>	$comments,
		    	'delicious'	=>	$delicious,
		    	'dribbble'	=>	$dribbble,
		    	'envato'	=>	$envato,
		    	'facebook'	=>	$facebook,
		    	'github'	=>	$github,
		    	'goodreads'	=>	$goodreads,
		    	'googleplus'	=>	$googleplus,
		    	'instagram'	=>	$instagram,
		    	'linkedin'	=>	$linkedin,
		    	'mailchimp'	=>	$mailchimp,
		    	'mixcloud'	=>	$mixcloud,
		    	'pinterest'	=>	$pinterest,
		    	'posts'	=>	$posts,
		    	'rss'	=>	$rss,
		    	'soundcloud'	=>	$soundcloud,
		    	'spotify'	=>	$spotify,
		    	'steam'	=>	$steam,
		    	'tumblr'	=>	$tumblr,
		    	'twitch'	=>	$twitch,
		    	'twitter'	=>	$twitter,
		    	'users'	=>	$users,
		    	'vimeo'	=>	$vimeo,
		    	'vine'	=>	$vine,
		    	'vk'	=>	$vk,
		    	'youtube'	=>	$youtube
		    );

		    $order_meta = $this->meta_values( $post->ID, array( 'field' => 'btnsx_order' ) );
		    if( $order_meta != '' ){
		    	$order = explode( ',', $order_meta );
		    }else{
		    	$order = array();
		    }

		    $new_order = array();
		    $order = array_filter( $order );
		    if( !empty( $order ) ){
		    	foreach ($order as $k) {
		    		$v = explode(':',$k);
		    		if( array_key_exists($v[0],$default_order) ){
		    			$new_order[$v[0]] = $default_order[$v[0]];
		    			unset($default_order[$v[0]]);
		    		}
		    	}
		    } else {
		    	$new_order = $default_order;
		    }

		    $final_order = array_merge( $elements, $new_order );
        	$btnsx_form_design = new BtnsxFormDesign();
        	$btnsx_default_options = array(
        		array(
					'icon_class'	=>	'fa fa-power-off',
					'text'			=>	__( 'Enable & Sort', 'btnsx' ),
					'elements'	=>	$final_order
				),
				array(
					'icon_class'	=>	'fa fa-paint-brush',
					'text'			=>	__( 'Theme', 'btnsx' ),
					'elements'	=>	array(
						array(
						    'type'			=>	'select',
						    'id'			=>	'btnsx_opt_theme',
						    'name'			=>	'btnsx_opt_theme',
						    'label'			=>	__( 'Select counter theme', 'btnsx' ),
						    'tooltip'		=>	__( 'Select theme for buttons.', 'btnsx' ),
						    'class'			=> 'btnsx-select',
						    'options'		=>	array(
						    	'theme1' => __( 'Theme 1', 'btnsx' ),
						    	'theme2' => __( 'Theme 2', 'btnsx' ),
						    	'theme3' => __( 'Theme 3', 'btnsx' ),
						    	'theme4' => __( 'Theme 4', 'btnsx' )
						    ),
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_theme', 'value' => 'theme1' ) )
					    )
					)
				)
	        );

			// filter to add custom options
        	$btnsx_filtered_options = apply_filters( 'btnsx_cs_options_filter', array(), $btnsx_default_options );
        	$btnsx_options = wp_parse_args( $btnsx_filtered_options, $btnsx_default_options );
        	$btnsx_form_design->tabs(
        		array(
        			'id'			=>	'btnsx-tabs-social-counters',
        			'outer_group'	=>	$btnsx_options
        		)
        	);
	    }

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 0.1
	     */
	    public function preview_callback( $post ) {
	    	$current_color = get_user_option( 'admin_color' );
	    	global $_wp_admin_css_colors;
	        ?>
	        <style type="text/css">
				.btnsx-tabs nav li.tab-current a {
				  color: <?php echo $_wp_admin_css_colors[$current_color]->colors[3]; ?>;
				}
				.ball-pulse>div {
				  background-color: <?php echo $_wp_admin_css_colors[$current_color]->colors[3]; ?>;
				}
				.btnsx .collapsible-header.active i {
					color: <?php echo $_wp_admin_css_colors[$current_color]->colors[3]; ?>;
				}
	        </style>
	        <!-- Loader -->
	        <div id="btnsx-preview-container" class="btnsx">
	        	<div id="btnsx-preview-loader" class="loader-inner ball-pulse" style="text-align:center;">
	        		<div></div>
	        		<div></div>
	        		<div></div>
	        	</div>
	        	<style type="text/css" id="btnsx-preview-css"></style>
	        </div>
	       	
	    	<?php
	    }

		/**
		* Adds the meta box container.
		* @since 0.1
		*/
		public function register_meta_boxes() {
			$screens = array( 'buttons-x-cs' );
			foreach ( $screens as $screen ) {
			    add_meta_box(
			        'btnsx-preview',
			        __( 'Live Preview', 'btnsx' ),
			        array( $this, 'preview_callback' ),
			        $screen,
			        'normal',
			        'high'
			    );
			    add_meta_box(
			        'btnsx-options',
			        __( 'Buttons X Options Panel', 'btnsx' ),
			        array( $this, 'options_callback' ),
			        $screen,
			        'normal',
			        'core'
			    );
			    add_meta_box(
			        'btnsx-shortcode',
			        __( 'Buttons X - Short Code', 'btnsx' ),
			        array( $this, 'shortcode_callback' ),
			        $screen,
			        'side',
			        'high'
			    );
			}
			global $btnsx_settings;
			$posts = isset( $btnsx_settings['social_counter'] ) ? $btnsx_settings['social_counter'] : '';
			// if( isset( $btnsx_settings['social_counter'] ) ) {
			// 	foreach ( $posts as $post ) {
			// 	    add_meta_box(
			// 	        'btnsx-cs',
			// 	        __( 'Buttons X - Social Counters', 'btnsx' ),
			// 	        array( $this, 'post_metabox_callback' ),
			// 	        $post,
			// 	        'side',
			// 	        'low'
			// 	    );
			// 	}
			// }
		}

		/**
         * Register custom taxonomies for button post type
         * @since  0.1
         * @return 
         */
        public function register_taxonomies() {
		    // Add new taxonomy, make it hierarchical (like categories)
		    $labels = array(
		        'name' 				=> _x( 'Packs', 'btnsx' ),
		        'singular_name' 	=> _x( 'Pack', 'btnsx' ),
		        'search_items' 		=> __( 'Search Pack', 'btnsx' ),
		        'all_items' 		=> __( 'All', 'btnsx' ),
		        'parent_item' 		=> __( 'Parent Pack', 'btnsx' ),
		        'parent_item_colon' => __( 'Parent Pack:', 'btnsx' ),
		        'edit_item' 		=> __( 'Edit Pack', 'btnsx' ),
		        'update_item' 		=> __( 'Update Pack', 'btnsx' ),
		        'add_new_item' 		=> __( 'Add New Pack', 'btnsx' ),
		        'new_item_name' 	=> __( 'New Pack Name', 'btnsx' ),
		        'menu_name' 		=> __( 'Packs', 'btnsx' )
		    );
		    $args = array(
		    	'public' 			=> false,
		        'hierarchical' 		=> true,
		        'labels' 			=> $labels,
		        'show_ui' 			=> true,
		        'show_admin_column' => true,
		        'query_var' 		=> true,
		        'rewrite' 			=> array( 'slug' => 'btnsx_cs_pack' ),
		    );
		    register_taxonomy( 'btnsx_cs_pack', array( 'buttons-x-cs' ), $args );
		    // Add new taxonomy, not hierarchical (like tags)
		    $labels = array(
		        'name' 				=> _x( 'Tags', 'btnsx' ),
		        'singular_name' 	=> _x( 'Tag', 'btnsx' ),
		        'search_items' 		=> __( 'Search Tag', 'btnsx' ),
		        'all_items' 		=> __( 'All', 'btnsx' ),
		        'parent_item' 		=> __( 'Parent Tag', 'btnsx' ),
		        'parent_item_colon' => __( 'Parent Tag:', 'btnsx' ),
		        'edit_item' 		=> __( 'Edit Tag', 'btnsx' ),
		        'update_item' 		=> __( 'Update Tag', 'btnsx' ),
		        'add_new_item' 		=> __( 'Add New Tag', 'btnsx' ),
		        'new_item_name' 	=> __( 'New Tag Name', 'btnsx' ),
		        'menu_name' 		=> __( 'Tags', 'btnsx' )
		    );
		    $args = array(
		    	'public' 			=> false,
		        'hierarchical' 		=> false,
		        'labels' 			=> $labels,
		        'show_ui' 			=> true,
		        'show_admin_column' => true,
		        'query_var' 		=> true,
		        'rewrite' 			=> array( 'slug' => 'btnsx_cs_tag' ),
		    );
		    register_taxonomy( 'btnsx_cs_tag', array( 'buttons-x-cs' ), $args );
		}

	    /**
        * Register the menu for the Dashboard.
        * @since 0.1
        */
        public function register_cpt() {
    		//	global $btnsx_settings;

            if( isset( $btnsx_settings['social_menu_name'] ) ){
                $button_menu_name = $btnsx_settings['social_menu_name'];
            } else {
                $button_menu_name = __('Social Counters', 'admin menu', 'btnsx');
            }

            if( isset( $btnsx_settings['social_name_singular'] ) ){
                $button_name_singular = $btnsx_settings['social_name_singular'];
            } else {
                $button_name_singular = __('Social Counter', 'post type singular name', 'btnsx');
            }

            if( isset( $btnsx_settings['social_name_plural'] ) ){
                $button_name_plural = $btnsx_settings['social_name_plural'];
            } else {
                $button_name_plural = __('Social Counters', 'post type general name', 'btnsx');
            }

            if( isset( $btnsx_settings['social_admin_bar_name'] ) ){
                $button_admin_bar_name = $btnsx_settings['social_admin_bar_name'];
            } else {
                $button_admin_bar_name = __('Social Counter', 'add new on admin bar', 'btnsx');
            }

            // Register buttons post
            register_post_type( 'buttons-x-cs',
                array(
                    'labels' => array(
                        'name' => $button_name_plural,
                        'singular_name' => $button_name_singular,
                        'menu_name' => $button_menu_name,
                        'name_admin_bar' => $button_admin_bar_name,
                        'add_new' => _x('Add New', $button_name_singular, 'btnsx'),
                        'add_new_item' => __('Add New ', 'btnsx') . $button_name_singular,
                        'new_item' => __('New ', 'btnsx') . $button_name_singular,
                        'edit_item' => __('Edit ', 'btnsx') . $button_name_singular,
                        'view_item' => __('View ', 'btnsx') . $button_name_singular,
                        'all_items' => $button_name_plural,
                        'search_items' => __('Search ', 'btnsx') . $button_name_plural,
                        'parent_item_colon' => __('Parent ', 'btnsx') . $button_name_plural . ':',
                        'not_found' => __('No ', 'btnsx') . $button_name_plural . __(' found.', 'btnsx'),
                        'not_found_in_trash' => __('No ', 'btnsx') . $button_name_plural . __(' found in Trash.', 'btnsx'),
                    ),
                    'public'                => false,
                    'show_ui'				=> true,
                    'exclude_from_search'   => true,
                    'publicly_queryable'    => false,
                    'has_archive'           => false,
                    'show_in_admin_bar'     => true,
                    'show_in_nav_menus'		=> true,
                    'show_in_menu'			=> 'btnsx',
                    'supports'              => array( 'title', 'btnsx_cs_pack', 'btnsx_cs_tag' )
                )
            );
        }

        /**
         * Convert integers to human readable form
         * @since  1.4.5
         * @param  string    $n
         * @return int
         */
        public function nice_number( $n ) {
	        // first strip any formatting;
	        $n = ( 0+str_replace( ',', '', $n ) );
	        
	        // is this a number?
	        if( !is_numeric( $n ) ) return false;
	        
	        // now filter it;
	        if( $n > 1000000000000 ) return round( ( $n/1000000000000 ), 1 ).'t';
	        else if( $n > 1000000000 ) return round( ( $n/1000000000 ), 1 ).'b';
	        else if( $n > 1000000 ) return round( ( $n/1000000 ), 1 ).'m';
	        else if( $n > 1000 ) return round( ( $n/1000 ), 1 ).'k';
	        
	        return number_format( $n );
	    }

	    /**
		 * Authorization.
		 *
		 * @param  string $hostname                  hostname.
		 * @param  string $consumer_key              Ccustomer key.
		 * @param  string $consumer_secret           Customer secret.
		 * @param  string $oaut_haccess_token        OAuth access token.
		 * @param  string $oauth_access_token_secret OAuth access token secret.
		 *
		 * @return string
		 */
		protected function tumbler_authorization( $hostname, $consumer_key, $consumer_secret, $oauth_access_token, $oauth_access_token_secret ) {
			$signature = $this->tumbler_signature( $hostname, $consumer_key, $consumer_secret, $oauth_access_token, $oauth_access_token_secret );
			return $this->tumbler_header( $signature );
		}
		/**
		 * Build the Signature base string.
		 *
		 * @param  string $url     Request URL.
		 * @param  string $query   Request query.
		 * @param  string $method  Request method.
		 * @param  string $params  OAuth params.
		 *
		 * @return string          OAuth Signature base.
		 */
		private function tumbler_signature_base_string( $url, $method, $params ) {
			$return = array();
			ksort( $params );
			foreach( $params as $key => $value ) {
				$return[] = $key . '=' . $value;
			}
			return $method . '&' . rawurlencode( $url ) . '&' . rawurlencode( implode( '&', $return ) );
		}
		/**
		 * Build the OAuth Signature.
		 *
		 * @param  string $hostname                  hostname.
		 * @param  string $consumer_key              Twitter customer key.
		 * @param  string $consumer_secret           Twitter customer secret.
		 * @param  string $oauth_access_token        OAuth access token.
		 * @param  string $oauth_access_token_secret OAuth access token secret.
		 *
		 * @return array                             OAuth signature params.
		 */
		private function tumbler_signature( $hostname, $consumer_key, $consumer_secret, $oauth_access_token, $oauth_access_token_secret ) {
			$oauth = array(
				'oauth_consumer_key'     => $consumer_key,
				'oauth_nonce'            => hash_hmac( 'sha1', time(), '1', false ),
				'oauth_signature_method' => 'HMAC-SHA1',
				'oauth_token'            => $oauth_access_token,
				'oauth_timestamp'        => time(),
				'oauth_version'          => '1.0'
			);
			$base_info = $this->tumbler_signature_base_string( sprintf( 'https://api.tumblr.com/v2/blog/%s/followers', $hostname ), 'GET', $oauth );
			$composite_key = rawurlencode( $consumer_secret ) . '&' . rawurlencode( $oauth_access_token_secret );
			$oauth_signature = base64_encode( hash_hmac( 'sha1', $base_info, $composite_key, true ) );
			$oauth['oauth_signature'] = $oauth_signature;
			return $oauth;
		}
		/**
		 * Build the header.
		 *
		 * @param  array $signature OAuth signature.
		 *
		 * @return string           OAuth Authorization.
		 */
		public function tumbler_header( $signature ) {
			$return = 'OAuth ';
			$values = array();
			foreach( $signature as $key => $value ) {
				$values[] = $key . '="' . rawurlencode( $value ) . '"';
			}
			$return .= implode( ', ', $values );
			return $return;
		}

        /**
         * Fetch likes
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_likes( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_fb_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_fb_' . $md5 );
        		global $btnsx_settings;
        		$token = isset( $btnsx_settings['social_counters_fb_access_token'] ) && $btnsx_settings['social_counters_fb_access_token'] != '' ? $btnsx_settings['social_counters_fb_access_token'] : '';
        		$http = 'https://graph.facebook.com/' . $url . '?fields=likes&access_token=' . $token;
        		$json = $this->get_counts( $http, '', 'likes' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_fb_' . $md5, $data, $this->cache ); // 12 hours
		 	} else {
		 		$data = get_transient( 'btnsx_fb_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	if( isset( $decode['likes'] ) ){
			 	return intval( $decode['likes'] );
		 	} else {
		 		return 0; 
		 	}
		}

		/**
         * Fetch tweets
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
		public function get_tweets( $md5, $id, $url ) {
			// delete_transient( 'btnsx_tw_' . $md5 );
			$value = get_transient( 'btnsx_tw_' . $md5 );
			if ( false === $value[1] || $url != $value[0] ) {
				delete_transient( 'btnsx_tw_' . $md5 );
				$http = 'https://api.twitter.com/1.1/users/show.json?screen_name=' . $url;
				$json = $this->get_counts( $http, '', 'twitter' );
				$data = array( $url, $json );
				set_transient( 'btnsx_tw_' . $md5, $data, $this->cache ); // 12 hours
		 	} else {
		 		$data = get_transient( 'btnsx_tw_' . $md5 );
		 	}
		    $decode = json_decode( $data[1], true );
		    // echo '<pre>'; print_r($decode); echo '</pre>';
		 	if( isset( $decode['followers_count'] ) ){
		 		return intval( $decode['followers_count'] );
		 	} else { return 0; }
		}
		 
		/**
         * Fetch plusones
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
		public function get_plusones( $md5, $id, $url ) {
			$value = get_transient( 'btnsx_po_' . $md5 );
			if ( false === $value[1] || $url != $value[0] ) {
				delete_transient( 'btnsx_po_' . $md5 );
				global $btnsx_settings;
        		$token = isset( $btnsx_settings['social_counters_gp_api_key'] ) && $btnsx_settings['social_counters_gp_api_key'] != '' ? $btnsx_settings['social_counters_gp_api_key'] : '';
				$http = 'https://www.googleapis.com/plus/v1/people/' . $url . '?key=' . $token;
				$json = $this->get_counts( $http, '', 'plusones' );
				$data = array( $url, $json );
				set_transient( 'btnsx_po_' . $md5, $data, $this->cache ); // 24 hours
		 	} else {
		 		$data = get_transient( 'btnsx_po_' . $md5 );
		 	}
		    $decode = json_decode( $data[1], true );
		    // var_dump($decode);
		 	if( isset($decode['circledByCount'] ) ){
		 		return intval( $decode['circledByCount'] );
		 	} else { return 0; }
		}

		/**
         * Fetch stumbles
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
		public function get_stumbles( $md5, $id, $url ) {
			$value = get_transient( 'btnsx_su_' . $md5 );
			if ( false === $value[1] || $url != $value[0] ) {
				delete_transient( 'btnsx_su_' . $md5 );
				$http = 'http://www.stumbleupon.com/services/1.01/badge.getinfo?url=' . $url;
				$json = $this->get_counts( $http, '', 'stumbles' );
				$data = array( $url, $json );
				set_transient( 'btnsx_su_' . $md5, $data, $this->cache ); // 12 hours
		 	} else {
		 		$data = get_transient( 'btnsx_su_' . $md5 );
		 	}
			$decode = json_decode( $data[1], true );
			if ( isset( $decode['result']['views'] ) ) {
				return intval( $decode['result']['views'] );
			} else { return 0; }
		}

		/**
         * Fetch youtube subscribers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
		public function get_yt_subscribers( $md5, $id, $url ) {
			$value = get_transient( 'btnsx_yt_' . $md5 );
			global $btnsx_settings;
			$app_id = isset( $btnsx_settings['social_counters_yt_app_id'] ) && $btnsx_settings['social_counters_yt_app_id'] != '' ? $btnsx_settings['social_counters_yt_app_id'] : '';
			$type = isset( $btnsx_settings['social_counters_yt_id_type'] ) && $btnsx_settings['social_counters_yt_id_type'] != '' ? $btnsx_settings['social_counters_yt_id_type'] : 'username';
			if( $type == 'channel' ){
				$user_type = 'id';
			}else{
				$user_type = 'forUsername';
			}
			if ( false === $value[1] || $url != $value[0] ) {
				delete_transient( 'btnsx_yt_' . $md5 );
				$http = 'https://www.googleapis.com/youtube/v3/channels?part=statistics&'.$user_type.'='.$url.'&key='.$app_id;
				$json = $this->get_counts( $http, '', 'youtube' );
				$data = array( $url, $json );
				set_transient( 'btnsx_yt_' . $md5, $data, $this->cache ); // 12 hours  - @TODO
		 	} else {
		 		$data = get_transient( 'btnsx_yt_' . $md5 );
		 	}
			$decode = json_decode( $data[1], true );
			if ( isset( $decode['items'][0]['statistics']['subscriberCount'] ) ) {
				return $decode['items'][0]['statistics']['subscriberCount'];
			} else { return 0; }
		}

		/**
         * Fetch vimeo subscribers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
		public function get_vm_subscribers( $md5, $id, $url ) {
			$value = get_transient( 'btnsx_vm_' . $md5 );
			if ( false === $value[1] || $url != $value[0] ) {
				delete_transient( 'btnsx_vm_' . $md5 );
				$http = 'https://api.vimeo.com/channels/'.$url;
				$json = $this->get_counts( $http, '', 'vimeo' );
				$data = array( $url, $json );
				set_transient( 'btnsx_vm_' . $md5, $data, $this->cache ); // 12 hours  - @TODO
		 	} else {
		 		$data = get_transient( 'btnsx_vm_' . $md5 );
		 	}
			$decode = json_decode( $data[1], true );
			// var_dump($data);
			if ( isset( $decode['metadata']['connections']['users']['total'] ) ) {
				return $decode['metadata']['connections']['users']['total'];
			} else { return 0; }
		}

		/**
         * Fetch dribbble followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_db_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_db_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_db_' . $md5 );
        		global $btnsx_settings;
				$token = isset( $btnsx_settings['social_counters_db_token'] ) && $btnsx_settings['social_counters_db_token'] != '' ? $btnsx_settings['social_counters_db_token'] : '';
        		$http = 'https://api.dribbble.com/v1/users/' . $url . '?access_token=' . $token;
        		$json = $this->get_counts( $http, '', 'dribbble' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_db_' . $md5, $data, $this->cache ); // 12 hours
		 	} else {
		 		$data = get_transient( 'btnsx_db_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['followers_count'] ) ){
			 	return intval( $decode['followers_count'] );
		 	} else {
		 		return 0; 
		 	}
		}

		/**
         * Fetch github followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_gh_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_gh_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_gh_' . $md5 );
        		global $btnsx_settings;
				$token = isset( $btnsx_settings['social_counters_gh_token'] ) && $btnsx_settings['social_counters_gh_token'] != '' ? $btnsx_settings['social_counters_gh_token'] : '';
        		$http = 'https://api.github.com/users/' . $url . '?access_token=' . $token;
        		$json = $this->get_counts( $http, '', 'github' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_gh_' . $md5, $data, $this->cache ); // 12 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_gh_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['followers'] ) ){
			 	return intval( $decode['followers'] );
		 	} else {
		 		return 0; 
		 	}
		}

		/**
         * Fetch envato followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_env_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_env_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_env_' . $md5 );
        		global $btnsx_settings;
				$token = isset( $btnsx_settings['social_counters_env_token'] ) && $btnsx_settings['social_counters_env_token'] != '' ? $btnsx_settings['social_counters_env_token'] : '';
        		$http = 'https://api.envato.com/v1/market/user:' . $url . '.json';
        		$json = $this->get_counts( $http, '', 'envato' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_env_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_env_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['user']['followers'] ) ){
			 	return intval( $decode['user']['followers'] );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch soundcloud followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_sc_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_sc_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_sc_' . $md5 );
        		global $btnsx_settings;
				$token = isset( $btnsx_settings['social_counters_sc_client_id'] ) && $btnsx_settings['social_counters_sc_client_id'] != '' ? $btnsx_settings['social_counters_sc_client_id'] : '';
        		$http = 'http://api.soundcloud.com/users/' . $url . '?consumer_key=' . $token;
        		$json = $this->get_counts( $http, '', 'soundcloud' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_sc_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_sc_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['followers_count'] ) ){
			 	return intval( $decode['followers_count'] );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch behance followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_be_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_be_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_be_' . $md5 );
        		global $btnsx_settings;
				$token = isset( $btnsx_settings['social_counters_be_client_id'] ) && $btnsx_settings['social_counters_be_client_id'] != '' ? $btnsx_settings['social_counters_be_client_id'] : '';
        		$http = 'http://www.behance.net/v2/users/' . $url . '?client_id=' . $token;
        		$json = $this->get_counts( $http, '', 'behance' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_be_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_be_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['user']['stats']['followers'] ) ){
			 	return intval( $decode['user']['stats']['followers'] );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch behance followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_del_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_del_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_del_' . $md5 );
        		$http = 'http://feeds.delicious.com/v2/json/userinfo/' . $url;
        		$json = $this->get_counts( $http, '', 'delicious' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_del_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_del_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode[2]['n'] ) ){
			 	return intval( $decode[2]['n'] );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch instagram followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_ig_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_ig_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_ig_' . $md5 );
        		global $btnsx_settings;
        		$token = isset( $btnsx_settings['social_counters_ig_access_token'] ) && $btnsx_settings['social_counters_ig_access_token'] != '' ? $btnsx_settings['social_counters_ig_access_token'] : '';
        		$http = 'https://api.instagram.com/v1/users/self/?access_token=' . $token;
        		$json = $this->get_counts( $http, '', 'instagram' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_ig_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_ig_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['data']['counts']['followed_by'] ) ){
			 	return intval( $decode['data']['counts']['followed_by'] );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch linkedin followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_li_followers( $md5, $id, $url ) {
        	delete_transient( 'btnsx_li_' . $md5 );
        	$value = get_transient( 'btnsx_li_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_li_' . $md5 );
        		global $btnsx_settings;
        		$token = isset( $btnsx_settings['social_counters_li_access_token'] ) && $btnsx_settings['social_counters_li_access_token'] != '' ? $btnsx_settings['social_counters_li_access_token'] : '';
        		// var_dump($token);
        		// $user = isset( $btnsx_settings['social_counters_li_user_id'] ) && $btnsx_settings['social_counters_li_user_id'] != '' ? $btnsx_settings['social_counters_li_user_id'] : '';
        		$http = 'https://api.linkedin.com/v1/people/~:(num-connections)?format=json';
        		$json = $this->get_counts( $http, '', 'linkedin' );
        		// var_dump($json);
        		$data = array( $url, $json );
        		set_transient( 'btnsx_li_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_li_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['numConnections'] ) ){
			 	return intval( $decode['numConnections'] );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch linkedin followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_pi_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_pi_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_pi_' . $md5 );
        		global $btnsx_settings;
        		$user = isset( $btnsx_settings['social_counters_pi_user_id'] ) && $btnsx_settings['social_counters_pi_user_id'] != '' ? $btnsx_settings['social_counters_pi_user_id'] : '';
        		$metas = get_meta_tags('https://pinterest.com/'.$user);
				$data = $metas['pinterestapp:followers'];
        		set_transient( 'btnsx_pi_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_pi_' . $md5 );
		 	}
		 	// var_dump($decode);
		 	if( $data != '' ){
			 	return intval( $data );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch vine followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_vi_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_vi_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_vi_' . $md5 );
        		// var_dump($token);
        		global $btnsx_settings;
        		$user = isset( $btnsx_settings['social_counters_vi_user_id'] ) && $btnsx_settings['social_counters_vi_user_id'] != '' ? $btnsx_settings['social_counters_vi_user_id'] : '';
        		$http = 'https://api.vineapp.com/users/profiles/' . $user;
        		$json = $this->get_counts( $http, '', 'vine' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_vi_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_vi_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['data']['followerCount'] ) ){
			 	return intval( $decode['data']['followerCount'] );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch spotify followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_si_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_si_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_si_' . $md5 );
        		// var_dump($token);
        		global $btnsx_settings;
        		$user = isset( $btnsx_settings['social_counters_si_user_id'] ) && $btnsx_settings['social_counters_si_user_id'] != '' ? $btnsx_settings['social_counters_si_user_id'] : '';
        		$user_type = isset( $btnsx_settings['social_counters_si_user_type'] ) && $btnsx_settings['social_counters_si_user_type'] != '' ? $btnsx_settings['social_counters_si_user_type'] : 'users';
        		$http = 'https://api.spotify.com/v1/' . $user_type . 's/' . $user;
        		$json = $this->get_counts( $http, '', 'spotify' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_si_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_si_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['followers']['total'] ) ){
			 	return intval( $decode['followers']['total'] );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch mixcloud followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_mix_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_mix_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_mix_' . $md5 );
        		// var_dump($token);
        		global $btnsx_settings;
        		$user = isset( $btnsx_settings['social_counters_mix_user_id'] ) && $btnsx_settings['social_counters_mix_user_id'] != '' ? $btnsx_settings['social_counters_mix_user_id'] : '';
        		$http = 'https://api.mixcloud.com/' . $user . '/?metadata=1';
        		$json = $this->get_counts( $http, '', 'mixcloud' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_mix_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_mix_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['follower_count'] ) ){
			 	return intval( $decode['follower_count'] );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch twitch followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_twi_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_twi_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_twi_' . $md5 );
        		// var_dump($token);
        		global $btnsx_settings;
        		$user = isset( $btnsx_settings['social_counters_twi_user_id'] ) && $btnsx_settings['social_counters_twi_user_id'] != '' ? $btnsx_settings['social_counters_twi_user_id'] : '';
        		$http = 'https://api.twitch.tv/kraken/channels/' . $user;
        		// var_dump($http);
        		$json = $this->get_counts( $http, '', 'twitch' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_twi_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_twi_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	// var_dump($decode);
		 	if( isset( $decode['followers'] ) ){
			 	return intval( $decode['followers'] );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch steam group members
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_stm_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_stm_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_stm_' . $md5 );
        		global $btnsx_settings;
        		$cache = isset( $btnsx_settings['social_counters_cache'] ) && $btnsx_settings['social_counters_cache'] != '' ? $btnsx_settings['social_counters_cache'] : '86400';
        		$user = isset( $btnsx_settings['social_counters_stm_user_id'] ) && $btnsx_settings['social_counters_stm_user_id'] != '' ? $btnsx_settings['social_counters_stm_user_id'] : '';
        		$meta = wp_remote_get( 'https://steamcommunity.com/groups/' . $user . '/memberslistxml/?xml=1', array( 'timeout' => 60 ) );
        		if ( is_wp_error( $meta ) || '400' <= $meta['response']['code'] ) {
					$data = 0;
				} else {
					try {
						$xml = @new SimpleXmlElement( $meta['body'], LIBXML_NOCDATA );
						$count = intval( $xml->groupDetails->memberCount );
						$data = $count;
					} catch ( Exception $e ) {
						$data = 0;
					}
				}
        		set_transient( 'btnsx_stm_' . $md5, $data, $cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_stm_' . $md5 );
		 	}
		 	// var_dump($decode);
		 	if( $data != '' ){
			 	return intval( $data );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch goodreads followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_gr_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_gr_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_gr_' . $md5 );
        		global $btnsx_settings;
        		$key = isset( $btnsx_settings['social_counters_gr_api_key'] ) && $btnsx_settings['social_counters_gr_api_key'] != '' ? $btnsx_settings['social_counters_gr_api_key'] : '';
        		$user = isset( $btnsx_settings['social_counters_gr_user_id'] ) && $btnsx_settings['social_counters_gr_user_id'] != '' ? $btnsx_settings['social_counters_gr_user_id'] : '';
        		$meta = wp_remote_get( 'https://www.goodreads.com/author/show.xml?key=' . $key . '/&id=' . $user, array( 'timeout' => 60 ) );
        		if ( is_wp_error( $meta ) || '400' <= $meta['response']['code'] ) {
					$data = 0;
				} else {
					try {
						$xml = @new SimpleXmlElement( $meta['body'], LIBXML_NOCDATA );
						$count = intval( $xml->author->author_followers_count );
						$data = $count;
					} catch ( Exception $e ) {
						$data = 0;
					}
				}
        		set_transient( 'btnsx_gr_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_gr_' . $md5 );
		 	}
		 	// var_dump($decode);
		 	if( $data != '' ){
			 	return intval( $data );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch vk followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_vk_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_vk_' . $md5 );
        	global $btnsx_settings;
    		$user = isset( $btnsx_settings['social_counters_vk_user_id'] ) && $btnsx_settings['social_counters_vk_user_id'] != '' ? $btnsx_settings['social_counters_vk_user_id'] : '';
    		$user_type = isset( $btnsx_settings['social_counters_vk_user_type'] ) && $btnsx_settings['social_counters_vk_user_type'] != '' ? $btnsx_settings['social_counters_vk_user_type'] : '';
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_vk_' . $md5 );
        		// var_dump($token);
        		if( $user_type == 'user' ){
        			$http = 'https://api.vk.com/method/users.get?user_ids=' . $user . '&fields=counters';
        		}else{
        			$http = 'https://api.vk.com/method/groups.getMembers?group_id=' . $user . '&count=0';
        		}
        		// var_dump($http);
        		$json = $this->get_counts( $http, '', 'vk' );
        		$data = array( $url, $json );
        		set_transient( 'btnsx_vk_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_vk_' . $md5 );
		 	}
		 	$decode = json_decode( $data[1], true );
		 	if( $user_type == 'user' ){
			 	if( isset( $decode['response'][0]['counters']['followers'] ) ){
				 	return intval( $decode['response'][0]['counters']['followers'] );
			 	} else {
			 		return 0;
			 	}
			}else{
				if( isset( $decode['response']['count'] ) ){
				 	return intval( $decode['response']['count'] );
			 	} else {
			 		return 0;
			 	}
			}
		}

		/**
         * Fetch tumblr group members
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_tbr_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_tbr_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_tbr_' . $md5 );
        		global $btnsx_settings;
        		$api_key = isset( $btnsx_settings['social_counters_tbr_api_key'] ) && $btnsx_settings['social_counters_tbr_api_key'] != '' ? $btnsx_settings['social_counters_tbr_api_key'] : '';
        		$api_secret = isset( $btnsx_settings['social_counters_tbr_api_secret'] ) && $btnsx_settings['social_counters_tbr_api_secret'] != '' ? $btnsx_settings['social_counters_tbr_api_secret'] : '';
        		$token = isset( $btnsx_settings['social_counters_tbr_token'] ) && $btnsx_settings['social_counters_tbr_token'] != '' ? $btnsx_settings['social_counters_tbr_token'] : '';
        		$token_secret = isset( $btnsx_settings['social_counters_tbr_token_secret'] ) && $btnsx_settings['social_counters_tbr_token_secret'] != '' ? $btnsx_settings['social_counters_tbr_token_secret'] : '';
        		$user_id = isset( $btnsx_settings['social_counters_tbr_user_id'] ) && $btnsx_settings['social_counters_tbr_user_id'] != '' ? $btnsx_settings['social_counters_tbr_user_id'] : '';
        		$meta_params = array( 
        			'method' => 'GET',
        			'timeout' => 60,
        			'headers' => array(
        				'Content-Type' => 'application/x-www-form-urlencoded',
        				'Authorization' => $this->tumbler_authorization(
        					$user_id,
							$api_key,
							$api_secret,
							$token,
							$token_secret
        				)
        			)
        		);
        		$meta = wp_remote_get( 'https://api.tumblr.com/v2/blog/' . $user_id . '/followers', $meta_params );
        		// var_dump($meta);
        		if ( is_wp_error( $meta ) || '400' <= $meta['response']['code'] ) {
					$data = 0;
				} else {
					try {
						$json = json_decode( $meta['body'], true );
						if ( isset( $json['response']['total_users'] ) ) {
							$count = intval( $json['response']['total_users'] );
							$data = $count;
						} else {
							$data = 0;
						}
					} catch ( Exception $e ) {
						$data = 0;
					}
				}
        		set_transient( 'btnsx_tbr_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_tbr_' . $md5 );
		 	}
		 	// var_dump($decode);
		 	if( $data != '' ){
			 	return intval( $data );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch 500px followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_fivepx_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_fivepx_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_fivepx_' . $md5 );
        		global $btnsx_settings;
        		$key = isset( $btnsx_settings['social_counters_fivepx_api_key'] ) && $btnsx_settings['social_counters_fivepx_api_key'] != '' ? $btnsx_settings['social_counters_fivepx_api_key'] : '';
        		$user = isset( $btnsx_settings['social_counters_fivepx_user_id'] ) && $btnsx_settings['social_counters_fivepx_user_id'] != '' ? $btnsx_settings['social_counters_fivepx_user_id'] : '';
        		$meta = wp_remote_get( 'https://api.500px.com/v1/users/show?username=' . $user . '&consumer_key=' . $key, array( 'timeout' => 60 ) );
        		if ( is_wp_error( $meta ) || '400' <= $meta['response']['code'] ) {
					$data = 0;
				} else {
					try {
						$json = json_decode( $meta['body'], true );
						if ( isset( $json['user']['followers_count'] ) ) {
							$count = intval( $json['user']['followers_count'] );
							$data = $count;
						} else {
							$data = 0;
						}
					} catch ( Exception $e ) {
						$data = 0;
					}
				}
        		set_transient( 'btnsx_fivepx_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_fivepx_' . $md5 );
		 	}
		 	// var_dump($decode);
		 	if( $data != '' ){
			 	return intval( $data );
		 	} else {
		 		return 0;
		 	}
		}

		/**
         * Fetch Mailchimp followers
         * @since  1.7.5
         * @param  string    $url
         * @return string
         */
        public function get_mc_followers( $md5, $id, $url ) {
        	$value = get_transient( 'btnsx_mc_' . $md5 );
        	if ( false === $value || $url != $value[0] ) {
        		delete_transient( 'btnsx_mc_' . $md5 );
        		global $btnsx_settings;
        		$key = isset( $btnsx_settings['social_counters_mc_api_key'] ) && $btnsx_settings['social_counters_mc_api_key'] != '' ? $btnsx_settings['social_counters_mc_api_key'] : '';
        		$center = isset( $key ) & $key != '' ? explode('-',$key) : '';
        		$list = isset( $btnsx_settings['social_counters_mc_list_id'] ) && $btnsx_settings['social_counters_mc_list_id'] != '' ? $btnsx_settings['social_counters_mc_list_id'] : '';
        		$type = isset( $btnsx_settings['social_counters_mc_type'] ) && $btnsx_settings['social_counters_mc_type'] != '' ? $btnsx_settings['social_counters_mc_type'] : 'total';
        		$params = array( 
    				'timeout' => 60,
    				'headers' => array(
    					'Authorization' => 'apikey ' . $key
    				)
    			);
    			$list_meta = wp_remote_get( 'https://'.$center[1].'.api.mailchimp.com/3.0/lists/' . $list, $params );
        		if( $type == 'total' ){
	        		$meta = wp_remote_get( 'https://'.$center[1].'.api.mailchimp.com/3.0/', $params );
	        	}else{
	        		$meta = $list_meta;
	        	}
        		if ( is_wp_error( $meta ) || '400' <= $meta['response']['code'] ) {
					$data = 0;
				} else {
					try {
						$json = json_decode( $meta['body'], true );
						$this->mc_list_url = isset( $json['subscribe_url_short'] ) && $json['subscribe_url_short'] != '' ? $json['subscribe_url_short'] : '#';
						if( $type === 'total' ){
							if ( isset( $json['total_subscribers'] ) ) {
								$count = intval( $json['total_subscribers'] );
								$data = $count;
							} else {
								$data = 0;
							}
						}else{
							if ( isset( $json['stats']['member_count'] ) ) {
								$count = intval( $json['stats']['member_count'] );
								$data = $count;
							} else {
								$data = 0;
							}
						}
					} catch ( Exception $e ) {
						$data = 0;
					}
				}
        		set_transient( 'btnsx_mc_' . $md5, $data, $this->cache ); // 24 hours
        		// var_dump($data);
		 	} else {
		 		$data = get_transient( 'btnsx_mc_' . $md5 );
		 	}
		 	// var_dump($decode);
		 	if( $data != '' ){
			 	return intval( $data );
		 	} else {
		 		return 0;
		 	}
		}

		/**
		 * fetch data using curl if available else use file_get_contents
		 * @since  1.7.5
		 * @param  string    $url
		 * @param  string    $post_fields
		 * @return string
		 */
		public function get_counts( $url, $post_fields, $service ){
			global $btnsx_settings;
			if( function_exists('curl_init') ){
				$curl = curl_init();
			    curl_setopt($curl, CURLOPT_URL, $url);
			    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			    if( $service === 'vimeo' ){
			    	$vm_app_id = isset( $btnsx_settings['social_counters_vm_app_id'] ) && $btnsx_settings['social_counters_vm_app_id'] != '' ? $btnsx_settings['social_counters_vm_app_id'] : '';
					$header = array();
					$header[] = 'Content-type: application/vnd.vimeo.channel+json';
					$header[] = 'Authorization: bearer '.$vm_app_id;
					curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
			    }elseif( $service === 'github' ){
			    	$header = array();
					$header[] = 'Content-type: application/json';
					$header[] = 'User-Agent: Buttons-X';
					curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
			    }elseif( $service === 'envato' ){
			    	$token = isset( $btnsx_settings['social_counters_env_token'] ) && $btnsx_settings['social_counters_env_token'] != '' ? $btnsx_settings['social_counters_env_token'] : '';
			    	$header = array();
					$header[] = 'Content-type: application/json';
					$header[] = 'Authorization: Bearer ' . $token;
					curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
			    }elseif( $service === 'linkedin' ){
			    	$token = isset( $btnsx_settings['social_counters_li_access_token'] ) && $btnsx_settings['social_counters_li_access_token'] != '' ? $btnsx_settings['social_counters_li_access_token'] : '';
			    	$header = array();
					$header[] = 'Connection: Keep-Alive';
					$header[] = 'Authorization: Bearer '.$token;
					curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
			    }elseif( $service === 'twitter' ){
			    	$token = isset( $btnsx_settings['social_counters_tw_access_token'] ) && $btnsx_settings['social_counters_tw_access_token'] != '' ? $btnsx_settings['social_counters_tw_access_token'] : '';
			    	$header = array();
					$header[] = 'Authorization: Bearer '.$token;
					curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
			    }else{
			    	curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-type: application/json'));
			    }
			    $data = curl_exec($curl);
			    curl_close($curl);
			} else {
				$data = file_get_contents($url);
			}
			return $data;
		}

	} // Main Class

}

/**
 *  Kicking this off
 */

$btn = new Btnsx_Counter_Social();
$btn->init();